<?PHP
class Admin{
	
	var $message;
	var $status=true;
	//obavezni atributi kod dodavanja novog korisnika
	var $obligatory_attr=array('uid','hrEduPersonOIB','userPassword','givenName','sn','mail','hrEduPersonPrimaryAffiliation','hrEduPersonExpireDate');
	//neobavezni atributi koji se pokazuju u formi kod dodavanja novog korisnika
	var $non_obligatory_attr=array('ou');
	var $forbidden_attr=array('hrEduPersonUniqueID','o','hrEduPersonHomeOrg','postalAddress','l');
	var $result;
	var $image;
	var $new_password=false;
	var $urn_attributes=array('ou','hrEduPersonAffiliation');
	var $debug=false;
	
	function get_select_attributes_html($param_array,$make_url,$message=false){
		
		$select_attrs_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$select_attrs_tpl->set_file('select_attrs', 'select_attrs_form.html');
		$select_attrs_tpl->set_block('select_attrs','attribute_row_tpl','attribute_row');
		
   	 	$schema=load_schema();
   	 	
   	 	$act_array=$param_array;
   	 	$act_array['show']='export_user_list';
   	 	$act_array['template']='export';
   	 	
   	 	$select_attrs_tpl->set_var('MESSAGE',$message);
   	 	$select_attrs_tpl->set_var('FORM_ACTION',$make_url->get_url($act_array));
   	 	$i=0;
   	 	foreach ($schema->attribute as $ldapname=>$attr){
   	 		if($this->debug){
   	 			print "Naziv:$ldapname\n";
   	 			print_r($attr);
   	 		}
   	 		if($attr->view['admin'] && $attr->type !='binary'  && $ldapname !='userPassword' ){
	   	 		$i++;
	   	 		$select_attrs_tpl->set_var('OPIS',$attr->desc);
	   	 		$select_attrs_tpl->set_var('NAZIV',$attr->name);
	   	 		$select_attrs_tpl->set_var('LDAPNAZIV',$ldapname);
	   	 		$select_attrs_tpl->set_var('NR',$i);
	   	 		$select_attrs_tpl->parse('attribute_row','attribute_row_tpl',true);
   	 		}
   	 	}
   	 	
		$select_attrs_tpl->parse('output', 'select_attrs');	
		return $select_attrs_tpl->get_var('output');
		
	}
	
	function get_selected_uids(){
		$list=$_POST['select'];
		$all_uids=$_POST['select_uid'];
		
		if($this->debug){
			print "selekitani chboxovi:\n";
			print_r($list);
			print "svi uidi:\n";
			print_r($all_uids);
		}
		
		if(is_array($list)){
			foreach ($list as $key=>$val) {
				$uid_array[]=$all_uids[$key];
			}
		}
		
		if($this->debug){
			print "selekitani uidi:\n";
			print_r($uid_array);
		}
		
		return $uid_array;
	}
	
	function get_new_pwd(){
		return $this->new_password;
	}
	
	function get_user_list_export($param_array){
		$schema=load_schema();
		list($filter,$nav_array)=$this->make_filter($param_array);
		$show_attrs='';
		
		$list=$_POST['select'];
		$all_attrs=$_POST['select_uid'];
		
		if($this->debug){
			print "Filter:$filter\n";
			print "selekitani chboxovi:\n";
			print_r($list);
			print "selekitani atributi:\n";
			print_r($all_attrs);
		}
		
		if(is_array($list)){
			foreach ($list as $key=>$val) {
				if($schema->attribute[$all_attrs[$key]]->view['admin'] && $schema->attribute[$all_attrs[$key]]->type !='binary'  && $schema->attribute[$all_attrs[$key]]->ldapname !='userPassword'){
					$attrs[]=$all_attrs[$key];
				}
			}
		}
		
		if(!is_array($attrs) || count($attrs)<1){
			$attrs=array('dn');
		}
		
		switch($_POST['export_encoding']){
			case 'UTF-8':
				$utf8_decode_to=false;
				break;
			case 'ISO-8859-2':
			case 'WINDOWS-1250':
				$utf8_decode_to=$_POST['export_encoding'];
				break;
			default:
				$utf8_decode_to='WINDOWS-1250';
			
		}
		if($filter){
   	 		$user_list=$this->get_user_list_all($filter,join(', ',$attrs),$utf8_decode_to);
   	 		$message.=$this->message;
   	 		if($this->debug){
   	 			print "encoding:$utf8_decode_to\n";
	   	 		print "<pre>";
	   	 		print_r($user_list);
	   	 		print "\n\n";
	   	 		print "message:" . $this->message ."\n";
	   	 		print "<pre>";
	   	 	}
 	 	}
 	 	$res=" dn";
 	 	foreach ($attrs as $ldapname){
 	 		if($ldapname!='dn'){
 	 			$res.=';' . $ldapname;
 	 		}
 	 	}
 	 	$res.="\n";
 	 	if(is_array($user_list) && count($user_list)>0){
   	 		foreach ($user_list as $dn => $val) {
   	 			$res.=$dn;
   	 			foreach ($attrs as $ldapname){
   	 				if($ldapname!='dn'){
	   	 				if(is_array($val[$ldapname])){
	   	 					$pom='';
	   	 					$val[$ldapname]=str_replace (array("\n","\r",";",","), array(" "," ", " "," "),$val[$ldapname]);
	   	 					foreach ($val[$ldapname] as $value){
	   	 						if($pom!=''){
	   	 							$pom.=',';
	   	 						}
	   	 						if($schema->attribute[$ldapname]->type =='date'){
	   	 							$pom.=conv_date_from_ldap($value);
	   	 						} else {
	   	 							$pom.=$value;
	   	 						}
	   	 					}
	   	 					$res.=';' . $pom;
	   	 				} else {
	   	 					$val[$ldapname]=str_replace (array("\n","\r",";"), array(" "," ", " "),$val[$ldapname]);
	   	 					if($schema->attribute[$ldapname]->type =='date'){
	 							$res.=';' . conv_date_from_ldap($val[$ldapname]);
	 						} else {
	 							$res.=';' . $val[$ldapname];
	 						}
	   	 				}
   	 				}
   	 			}
   	 			$res.="\n";
   	 		}
   	 		return $res;
 	 	} else {
 	 		return m(52);
 	 	}
	}
	
	function make_filter($filt_array){
		global $simple_filter_fields;
		$filter='';
		$schema=load_schema();
		if($this->debug){
			print "<pre>\n\n***** Admin::make_filter *****\n";
			print "simple_filter_fields:\n";
			print_r($simple_filter_fields);
			print "\nfilt_array:\n";
			print_r($filt_array);
			print "</pre>";
		}
		foreach ($simple_filter_fields as $equality=>$fields){
			switch($equality){
   	 			case 'less_or_equal':
   	 				$oper='<=';
   	 				$suff='_le';
   	 			break;
   	 			case 'greater_or_equal':
   	 				$oper='>=';
   	 				$suff='_ge';
   	 			break;
   	 			default:
   	 				$oper='=';
   	 				$suff='_e';
   	 			break;
   	 		}
			foreach ($fields as $ldapname){		
	   	 		if(isset($filt_array[$ldapname . $suff]) && trim($filt_array[$ldapname . $suff])!=''){
	   	 			if($schema->attribute[$ldapname]->type=='date' && is_numeric(substr(trim($filt_array[$ldapname . $suff]),0,1))){
	   	 				$filter.="($ldapname" . $oper . conv_date_to_ldap(trim($filt_array[$ldapname . $suff])) .')';
	   	 			} else {
						$filter.="($ldapname" . $oper . trim($filt_array[$ldapname . $suff]) .')';
	   	 			}
					$nav_array[$ldapname . $suff]=trim($filt_array[$ldapname . $suff]);
				}
				if($this->debug){
					print "<pre>\n\n***** Admin::make_filter *****\n";
					print "equality:$equality\n";
					print "ldapname:$ldapname\n";
					print "filter:$filter\n";
					print "</pre>";
				}
	   	 	}
		}
   	 	if($filter){
   	 		$filter="(&$filter)";
   	 	} else {
   	 		$filter.=DEFAULT_USER_LIST_FILTER;
   	 	}
   	 	
   	 	return array($filter,$nav_array);
	}
	
	function get_user_list_html($param_array,$make_url,$message=false){
		$get_attrs=array('uid','cn','hrEduPersonUniqueNumber','hrEduPersonExpireDate','hrEduPersonPrimaryAffiliation');
		
		$show_attrs=array(	'uid'=>array('type'=>'link',
										'text'=>m(54)),
							'cn'=>array('type'=>'string',
										'text'=>m(55)),
							'hrEduPersonUniqueNumber'=>array('type'=>'string',
															'text'=>m(56)),
							'hrEduPersonPrimaryAffiliation'=>array('type'=>'string',
															'text'=>m(57)),
							'hrEduPersonExpireDate'=>array('type'=>'date',
															'text'=>m(58)),
							'aosi_spec'=>array('type'=>'delete',
												'text'=>m(59)));
		
		$user_list_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$user_list_tpl->set_file('user_list', 'user_list.html');

		if(isset($_POST['filter'])){
   	 		$page=1;
   	 		$filt_array=$_POST;
   	 	} else {
   	 		$page=$param_array['page'];
   	 		$filt_array=$param_array;
   	 	}
		
   	 	
   	 	
   	 	if(!$page){
   	 		$page=1;
   	 	} 		
   	 	$from=($page -1) * ITEMS_PER_PAGE;
 		
   	 	if($this->debug){
   	 		print "<pre>filter array:";
   	 		print_r($filt_array);
   	 		print "\n<pre>";
   	 	}
   	 	
   	 	list($filter,$nav_array)=$this->make_filter($filt_array);
   	 	$nav_array['page']=$page;
   	 	$nav_array['show']='user_list';
   	 	
   	 	$user_list_tpl->set_var('FILTER',$this->get_filter_fields_html($filt_array));
   	 	
   	 	if($this->debug){
   	 		print "<pre>filter:$filter\n<pre>";
   	 	}
		if($param_array['noquery']!='true'){
	   	 	if($user_list=$this->get_user_list($filter,join(', ',$get_attrs),$from,ITEMS_PER_PAGE)){
		   	 	if(is_array($user_list['user_list']) && count($user_list['user_list'])>0){
		   	 		if($this->debug){
		   	 			print "Lista korisnika:\n";
		   	 			print_r($user_list);
		   	 		}
					$user_list_tpl->set_var('LIST_TABLE',$this->get_list_table_html($show_attrs,$user_list,$make_url,$nav_array,true,$page));
		   	 	} else {
		   	 		$user_list_tpl->set_var('LIST_TABLE',m(52));
		   	 	}
	   	 	} else {
	   	 		$message=$this->message;
	   	 		$user_list_tpl->set_var('LIST_TABLE',m(52));
		   	}
		} else {
   	 		$user_list_tpl->set_var('LIST_TABLE',m(99));
	   	}
	   	
		$user_list_tpl->set_var('MESSAGE',$message);
		
   	 	$user_list_tpl->parse('output', 'user_list');	
		return $user_list_tpl->get_var('output');
		
	}
	
	
	
	function get_select_users_form_html($type='extend',$param_array,$make_url,$message=false){
		$get_attrs=array('uid','cn','hrEduPersonUniqueNumber','hrEduPersonExpireDate','hrEduPersonPrimaryAffiliation');
		
		$show_attrs=array(	'uid'=>array('type'=>'link',
										'text'=>m(54)),
							'cn'=>array('type'=>'string',
										'text'=>m(55)),
							'hrEduPersonUniqueNumber'=>array('type'=>'string',
															'text'=>m(56)),
							'hrEduPersonPrimaryAffiliation'=>array('type'=>'string',
															'text'=>m(57)),
							'hrEduPersonExpireDate'=>array('type'=>'date',
															'text'=>m(58)),
							'aosi_spec'=>array('type'=>'select',
												'text'=>m(60)));
		
		$user_list_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
		switch ($type){
   	 		case 'delete':
   	 			$user_list_tpl->set_file('select_users', 'delete_users_form.html');
   	 			break;
   	 		default:
				$user_list_tpl->set_file('select_users', 'extend_users_form.html');
		}
		$filt_array=$_POST;
		if(isset($filt_array['filter'])){
	   	 	
	   	 	
	   	 	unset($filt_array['page']);
	 		
	   	 	if($this->debug){
	   	 		print "<pre>filter array:";
	   	 		print_r($filt_array);
	   	 		print "\n<pre>";
	   	 	}
	   	 	
	   	 	list($filter,$nav_array)=$this->make_filter($filt_array);
		}	   	 	
   	 	$user_list_tpl->set_var('FILTER',$this->get_filter_fields_html($filt_array));
   	 	
   	 	if($this->debug){
   	 		print "<pre>filter:$filter\n<pre>";
   	 	}
		if($filter){
	   	 	if($user_list=$this->get_user_list_all($filter,join(', ',$get_attrs))){
		   	 	if(is_array($user_list) && count($user_list)>0){
		   	 		$user_list=array('count'=>count($user_list),'user_list'=>$user_list);
		   	 		if($this->debug){
		   	 			print "Lista korisnika:\n";
		   	 			print_r($user_list);
		   	 		}
		   	 		$nav_array['show']='extend_users_form';
					$user_list_tpl->set_var('LIST_TABLE',$this->get_list_table_html($show_attrs,$user_list,$make_url,$nav_array,false));
		   	 	} else {
		   	 		$user_list_tpl->set_var('LIST_TABLE',m(52));
		   	 	}
	   	 	} else {
	   	 		$message=$this->message;
	   	 		$user_list_tpl->set_var('LIST_TABLE',m(52));
		   	}
	   	} else {
   	 		$message=$this->message;
   	 		$user_list_tpl->set_var('LIST_TABLE',m(52));
	   	}
		$user_list_tpl->set_var('MESSAGE',$message);
		
   	 	$user_list_tpl->parse('output', 'select_users');	
		return $user_list_tpl->get_var('output');
		
	}
	
	function get_filter_fields_html($filt_array){
		global $simple_filter_fields;
		$filter_fields_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$filter_fields_tpl->set_file('filter_fields', 'filter_fields.html');
   	 	$filter_fields_tpl->set_block('filter_fields','filter_input_tpl','filter_input');
   	 	$filter_fields_tpl->set_block('filter_input_tpl','filter_string_tpl','filter_string');
   	 	$filter_fields_tpl->set_block('filter_input_tpl','filter_vocabulary_tpl','filter_vocabulary');
   	 	$filter_fields_tpl->set_block('filter_vocabulary_tpl','vocabulary_option_tpl','vocabulary_option');
   	 	
   	 	if($_SESSION['admintype']==3){
	   	 	$admin_privileges=$this->get_admin_privileges();
	   	 	if($this->debug){
	   	 		print "admintype=3\nprivileges:\n";
	   	 		print_r($admin_privileges);
	   	 	}
   	 	}
   	 	$schema=load_schema();
   	 	foreach ($simple_filter_fields as $equality=>$arr) {
   	 		switch($equality){
   	 			case 'less_or_equal':
   	 				$oper='<=';
   	 				$suff='_le';
   	 			break;
   	 			case 'greater_or_equal':
   	 				$oper='>=';
   	 				$suff='_ge';
   	 			break;
   	 			default:
   	 				$oper='=';
   	 				$suff='_e';
   	 			break;
   	 		}
   	 		foreach ($arr as $ldapname) {
   	 			if($this->debug){
		   	 		print "attribute:$ldapname\n";
		   	 	}
		   	 	
   	 			$field=trim($filt_array[$ldapname . $suff]);
   	 			$filter_fields_tpl->set_var('OPIS',$schema->attribute[$ldapname]->desc);
   	 			$filter_fields_tpl->set_var('NAZIV',$schema->attribute[$ldapname]->name);
   	 			$filter_fields_tpl->set_var('LDAPNAZIV',$ldapname);
   	 			$filter_fields_tpl->set_var('INPUT_LDAPNAZIV',$ldapname . $suff);
   	 			$filter_fields_tpl->set_var('EQUALITY',$oper);
   	 			if($schema->attribute[$ldapname]->type=='vocabulary'){
   	 				if($this->debug){
			   	 		print "type:vocabulary\n";
			   	 	}
   	 				$filter_fields_tpl->set_var('vocabulary_option','');
   	 				if($_SESSION['admintype']==3 && is_array($admin_privileges[$ldapname])){
   	 					if($this->debug){
				   	 		print "admintype=3\nreducing vocabulary.\n";
				   	 	}
   	 					$vocabulary=$admin_privileges[$ldapname];
   	 				} else {
   	 					$vocabulary=$schema->attribute[$ldapname]->vocabulary;
   	 				}
   	 				$filter_fields_tpl->set_var('VRIJEDNOST','');
 					$filter_fields_tpl->set_var('VRIJEDNOST_OPIS',m(53));
 					$filter_fields_tpl->set_var('SELECTED','');
 					$filter_fields_tpl->parse('vocabulary_option','vocabulary_option_tpl',true);
   	 				if($this->debug){
   	 					print "vocabulary:\n";
   	 					print_r($vocabulary);
   	 				}
   	 				foreach ($vocabulary as $key => $val) {
   	 					$filter_fields_tpl->set_var('VRIJEDNOST',$key);
   	 					$filter_fields_tpl->set_var('VRIJEDNOST_OPIS',$val);
   	 					if($field==$key){
   	 						$filter_fields_tpl->set_var('SELECTED','SELECTED');
   	 					} else {
   	 						$filter_fields_tpl->set_var('SELECTED','');
   	 					}
   	 					$filter_fields_tpl->parse('vocabulary_option','vocabulary_option_tpl',true);
   	 				}
   	 				$filter_fields_tpl->parse('filter_vocabulary','filter_vocabulary_tpl');
   	 				$filter_fields_tpl->set_var('filter_string','');
   	 			} else {
   	 				if($this->debug){
			   	 		print "type:string\n";
			   	 	}
   	 				$filter_fields_tpl->set_var('filter_vocabulary','');
   	 				$filter_fields_tpl->set_var('VRIJEDNOST',$field);
   	 				$filter_fields_tpl->parse('filter_string','filter_string_tpl');
   	 			}
   	 			$filter_fields_tpl->parse('filter_input','filter_input_tpl',true);
   	 		}
   	 		
   	 	}
		$filter_fields_tpl->parse('output', 'filter_fields');	
		return $filter_fields_tpl->get_var('output');
	}
	
	function get_list_table_html($show_attrs,$user_list,$make_url,$nav_array=false,$show_nav=true,$current_page=1){
		
		$list_table_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$list_table_tpl->set_file('list_table', 'list_table.html');
   	 	$list_table_tpl->set_block('list_table','header_cell_tpl','header_cell');
   	 	$list_table_tpl->set_block('list_table','table_row_tpl','table_row');
   	 	$list_table_tpl->set_block('table_row_tpl','table_cell_tpl','table_cell');
   	 	$list_table_tpl->set_block('table_cell_tpl','url_cell_tpl','url_cell');
   	 	$list_table_tpl->set_block('table_cell_tpl','value_cell_tpl','value_cell');
   	 	$list_table_tpl->set_block('table_cell_tpl','delete_cell_tpl','delete_cell');
   	 	$list_table_tpl->set_block('table_cell_tpl','select_cell_tpl','select_cell');
   	 	$list_table_tpl->set_block('list_table','navigation_row_tpl','navigation_row');
		
   	 	$cols=count($show_attrs);
		$list_table_tpl->set_var('COLSPAN',$cols);
		
		foreach ($show_attrs as $ldapname=>$val){
			$list_table_tpl->set_var('HEADER_TEXT',$val['text']);
			$list_table_tpl->parse('header_cell','header_cell_tpl',true);
		}
   	 	
		$count=$user_list['count'];
		$list_table_tpl->set_var('COUNT',$count);
		$i=0;
		
		$del_array=$nav_array;
		$del_array['action']='delete_user';
		
		foreach ($user_list['user_list'] as $dn=>$attr_vals) {
			$i++;
			$list_table_tpl->set_var('table_cell','');
			foreach ($show_attrs as $ldapname => $attr_spec) {
				
				switch ($attr_spec['type']) {
					case 'date':
						$attr_vals[$ldapname]=conv_date_from_ldap($attr_vals[$ldapname]);
					case 'string':
					case 'link':
						$vr='';
						if(is_array($attr_vals[$ldapname])){
							foreach ($attr_vals[$ldapname] as $value) {
								if($vr!=''){	
									$vr.='<br>';	
								}
								$vr.=$value;
							}
						} else {
							$vr=$attr_vals[$ldapname];
						}
						break;
					case 'delete':
					case 'select':
						$vr=$attr_vals['uid'];
						break;
				}
				$list_table_tpl->set_var('VALUE',$vr);
				
				switch ($attr_spec['type']) {
					case 'date':
					case 'string':
						$list_table_tpl->set_var('url_cell','');
						$list_table_tpl->set_var('delete_cell','');
						$list_table_tpl->set_var('select_cell','');
						$list_table_tpl->parse('value_cell','value_cell_tpl');
						break;
					case 'link':
						$list_table_tpl->set_var('URL','index.php?show=edit_user&attributes=must&uida=' . $attr_vals['uid']);
						
						$list_table_tpl->set_var('value_cell','');
						$list_table_tpl->set_var('delete_cell','');
						$list_table_tpl->set_var('select_cell','');
						$list_table_tpl->parse('url_cell','url_cell_tpl');
						break;
					case 'delete':
						$del_array['uida']=$attr_vals['uid'];
						$list_table_tpl->set_var('URL',$make_url->get_url($del_array));
						$list_table_tpl->set_var('url_cell','');
						$list_table_tpl->set_var('value_cell','');
						$list_table_tpl->set_var('select_cell','');
						$list_table_tpl->parse('delete_cell','delete_cell_tpl');
						break;
					case 'select':
						$list_table_tpl->set_var('NR',$i);
						$list_table_tpl->set_var('url_cell','');
						$list_table_tpl->set_var('delete_cell','');
						$list_table_tpl->set_var('value_cell','');
						$list_table_tpl->parse('select_cell','select_cell_tpl');
						break;
				}
				$list_table_tpl->parse('table_cell','table_cell_tpl',true);
			}
			$list_table_tpl->set_var('ROW_CLASS',($i%2==1) ? 'odd_row' : 'even_row' );
			$list_table_tpl->parse('table_row','table_row_tpl',true);
			
		}
		$export_arr=$nav_array;
		$export_arr['module']=$export_arr['show'];
		$export_arr['show']='select_attributes_for_export';
		$list_table_tpl->set_var('EXPORT_URL',$make_url->get_url($export_arr));
		if($show_nav){
			$last=(int) floor($count / ITEMS_PER_PAGE);						
			if ($count % ITEMS_PER_PAGE >0 ){
				$last++;
			}
			require_once(CLASS_INCLUDE_PATH . 'navigation/navigation.php');
			$nav=new Navigation($make_url,$nav_array,1,$last,$current_page);
			$list_table_tpl->set_var('NAVIGATION', $nav->get_html());
			$list_table_tpl->parse('navigation_row','navigation_row_tpl');
		} else {
			$list_table_tpl->set_var('navigation_row','');
		}
		$list_table_tpl->parse('output', 'list_table');	
		return $list_table_tpl->get_var('output');
	}
	
	function get_admin_privileges(){
		$admin_privileges=unserialize($_SESSION['admin_privileges']);
   	 	if(is_array($admin_privileges)){
   	 		foreach ($admin_privileges as $arr) {
   	 			if(is_array($arr)){
	   	 			foreach ($arr as $ldapname=>$values) {
	   	 				foreach($values as $key=>$value){
	   	 					if($ldapname=='hrEduPersonAffiliation'){
	   	 						$admin['hrEduPersonPrimaryAffiliation'][$value]=$value;
	   	 					}
	   	 					$admin[$ldapname][$value]=$value;
	   	 				}
	   	 			}
   	 			}
   	 		}
   	 	}
   	 	return $admin;
	}
	
	function get_admin_list_html($message=false){
		//print $message;
		$admin_list_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$admin_list_tpl->set_file('admin_list', 'admin_list.html');
   	 	$admin_list_tpl->set_block('admin_list','table_row_tpl','table_row');
   	 	$admin_list_tpl->set_block('table_row_tpl','change_tpl','change');
   	 	$admin_list_tpl->set_block('table_row_tpl','revoke_tpl','revoke');
   	 	
   	 	require_once(CLASS_INCLUDE_PATH . 'login/login.php');
		$login=new Login();
		$admin_list=$login->get_admin_privileges($_SESSION['uid'],$_SESSION['password']);
   	 	if($this->debug){
   	 		print "admin privileges:\n";
   	 		print_r($admin_list);
   	 	}
		if(is_array($admin_list)){
			$i=0;
			foreach ($admin_list as $dn=>$priv){
				list($uid,$pom)=explode(',',substr($dn,4),2);
				$uid=trim($uid);
				
				if($uid){
					$i++;
					$user_data=$this->get_user_data($uid,'cn',true);
					if(is_array($user_data)){
						if(is_array($user_data[$dn]['cn'])){
							$cn=array_pop($user_data[$dn]['cn']);
						} else {
							$cn=$user_data[$dn]['cn'];
						}
					} else {
						$cn=m(38) . " " . m(81);
					}
					$admin_list_tpl->set_var('UID',$uid);
					$admin_list_tpl->set_var('CN',$cn);
					$admin_list_tpl->set_var('ROW_CLASS',($i%2==1) ? 'odd_row' : 'even_row' );
					$admin_list_tpl->set_var('URL_EDIT_USER','index.php?show=edit_user&attributes=all&uida=' . $uid);
					switch ($priv['aosi_admintype']){
						case 1:
							$adm_type_text=m(82);
							$show_revoke=false;
						break;
						case 2:
							$adm_type_text=m(83);
							$show_revoke=true;
						break;
						case 3:
							$adm_type_text=m(84);
							$show_revoke=true;
						break;
						default:
							$adm_type_text=m(38) . " " . m(81);
							$show_revoke=false;
					}
					
					$admin_list_tpl->set_var('ADMIN_TYPE',$adm_type_text);
					$admin_list_tpl->set_var('URL_EDIT_ADMIN','index.php?show=edit_admin&uida=' . $uid);
					$admin_list_tpl->set_var('URL_DELETE_ADMIN','index.php?show=admin_list&action=revoke_admin_privileges&uida=' . $uid);
					if($show_revoke){
						if($_SESSION['admintype']==3){
							$admin_list_tpl->set_var('revoke','');
							$show_revoke=false;
						} else {
							$admin_list_tpl->parse('revoke','revoke_tpl');
						}
						$admin_list_tpl->parse('change','change_tpl');
					} else {
						$admin_list_tpl->set_var('revoke','');
						$admin_list_tpl->set_var('change','');
					}
					$admin_list_tpl->parse('table_row','table_row_tpl',true);
				} else {
					$message.=m(38) . " " . m(80) . " " . $dn;
				}
			}
			
		} else {
			$admin_list_tpl->set_var('table_row',m(52));
		}  	 	
   	 	
   	 	$admin_list_tpl->set_var('MESSAGE',$message);
   	 	$admin_list_tpl->parse('output', 'admin_list');	
		return $admin_list_tpl->get_var('output');
	}
	
	function get_edit_admin_html($uid,$message=false){
		//print $message;
		$attrs=$this->urn_attributes;
		$uid=trim($uid);
		$edit_admin_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$edit_admin_tpl->set_file('edit_admin', 'edit_admin.html');
   	 	$edit_admin_tpl->set_block('edit_admin','revoke_tpl','revoke');
   	 	$edit_admin_tpl->set_block('edit_admin','ou_row_tpl','ou_row');
   	 	
   	 	$edit_admin_tpl->set_block('ou_row_tpl','ou_delete_tpl','ou_delete');
   	 	$edit_admin_tpl->set_block('edit_admin','hredupersonaffiliation_row_tpl','hredupersonaffiliation_row');
   	 	$edit_admin_tpl->set_block('hredupersonaffiliation_row_tpl','hredupersonaffiliation_delete_tpl','hredupersonaffiliation_delete');
   	 	
   	 	foreach ($attrs as $ldapname){
   	 		$edit_admin_tpl->set_block('edit_admin','add_new_priv_' . $ldapname . '_tpl','add_new_priv_' . $ldapname);
   	 	}
   	 	
   	 	require_once(CLASS_INCLUDE_PATH . 'login/login.php');
		$login=new Login();
		$admin_list=$login->get_admin_privileges($_SESSION['uid'],$_SESSION['password'],$uid);
   	 	$edit_admin_tpl->set_var('UID',$uid);
   	 	if($this->debug){
   	 		print "admin privileges:\n";
   	 		print_r($admin_list);
   	 	}
		if(is_array($admin_list)){
			$admin_type=$admin_list['aosi_admintype'];
			switch ($admin_type){
				case 1:
					$adm_type_text=m(82);
					$show_revoke=false;
				break;
				case 2:
					$adm_type_text=m(83);
					$show_revoke=true;
				break;
				case 3:
					$adm_type_text=m(84);
					$show_revoke=true;
				break;
				default:
					$adm_type_text=m(38) . " " . m(81);
					$show_revoke=false;
			}
			if($_SESSION['admintype']==3){
				$show_revoke=false;
				foreach ($attrs as $ldapname){
					$edit_admin_tpl->set_var('add_new_priv_' . $ldapname,'');
				}
			} else {
				foreach ($attrs as $ldapname){
					$edit_admin_tpl->parse('add_new_priv_' . $ldapname,'add_new_priv_' . $ldapname . '_tpl');
				}
			}
			$edit_admin_tpl->set_var('ADMIN_TYPE',$adm_type_text);
			$edit_admin_tpl->set_var('URL_EDIT_USER','index.php?show=edit_user&attributes=all&uida=' . $uid);
			$edit_admin_tpl->set_var('URL_DELETE_ADMIN','index.php?show=admin_list&action=revoke_admin_privileges&uida=' . $uid);
			if($show_revoke){
				$edit_admin_tpl->parse('revoke','revoke_tpl');
			} else {
				$edit_admin_tpl->set_var('revoke','');
			}
			
			if($admin_type==3){
				unset($admin_list['aosi_admintype']);
				if(is_array($admin_list) && count($admin_list)>0){
					$priv=array_pop($admin_list);
					$urn_value=urlencode(base64_encode(serialize($priv)));
					foreach ($attrs as $ldapname){
						if(is_array($priv[$ldapname])){
							foreach ($priv[$ldapname] as $val){
								$edit_admin_tpl->set_var(strtoupper($ldapname),$val);
								$edit_admin_tpl->set_var('OBRISI_URL','index.php?action=revoke_privilege&show=edit_admin&ldapname=' . $ldapname . '&uida='. $uid . '&privilege_value=' . urlencode(base64_encode($val)) . '&old_urn_value=' . $urn_value);
								if($_SESSION['admintype']==3){
									$edit_admin_tpl->set_var(strtolower($ldapname) . '_delete','');
								} else {
									$edit_admin_tpl->parse(strtolower($ldapname) . '_delete',strtolower($ldapname) . '_delete_tpl');
								}
								$edit_admin_tpl->parse(strtolower($ldapname) . '_row',strtolower($ldapname) . '_row_tpl',true);
							}
						} else {
							$edit_admin_tpl->set_var(strtoupper($ldapname),m(87));
							$edit_admin_tpl->set_var(strtolower($ldapname) . '_delete','');
							$edit_admin_tpl->parse(strtolower($ldapname) . '_row',strtolower($ldapname) . '_row_tpl');
						}
					}
				} else {
					$edit_admin_tpl->set_var('OU',m(87));
					$edit_admin_tpl->set_var('HREDUPERSONAFFILIATION',m(87));
					$edit_admin_tpl->set_var('ou_delete','');
					$edit_admin_tpl->set_var('hredupersonaffiliation_delete','');
					$edit_admin_tpl->parse('ou_row','ou_row_tpl');
					$edit_admin_tpl->parse('hredupersonaffiliation_row','hredupersonaffiliation_row_tpl');
				}
			} else {
				$edit_admin_tpl->set_var('OU',m(87));
				$edit_admin_tpl->set_var('HREDUPERSONAFFILIATION',m(87));
				$edit_admin_tpl->set_var('ou_delete','');
				$edit_admin_tpl->set_var('hredupersonaffiliation_delete','');
				$edit_admin_tpl->parse('ou_row','ou_row_tpl');
				$edit_admin_tpl->parse('hredupersonaffiliation_row','hredupersonaffiliation_row_tpl');
			}
		} else {
			$edit_admin_tpl->set_var('ou_row',m(38) . " " . m(81));
			$edit_admin_tpl->set_var('hredupersonaffiliation_row',m(38) . " " . m(81));
			$edit_admin_tpl->set_var('revoke','');
			$message.=m(38) . " " . m(81);
		}
		$edit_admin_tpl->set_var('URN_VALUE',$urn_value);
   	 	$edit_admin_tpl->set_var('MESSAGE',$message);
   	 	$edit_admin_tpl->parse('output', 'edit_admin');	
		return $edit_admin_tpl->get_var('output');
	}
	
	function make_urn($urn_value){
		$urn='';
		$attrs=$this->urn_attributes;
		foreach ($attrs as $ldapname){
			if(is_array($urn_value[$ldapname])){
				foreach ($urn_value[$ldapname] as $pvalue){
					if($urn!=''){
						$urn.=':';
					}
					$urn.=$ldapname . ":" . $pvalue;
				}
			}
		}
		if($urn && $urn!=''){
			$urn="urn:administrator imenika:" . $urn;
		} else {
			$urn="administrator imenika";
		}
		return $urn;
	}
	
	function change_admin_privilege($param_array){
		$actions=array('add_privilege','revoke_privilege');
		$attrs=$this->urn_attributes;
		$uid=trim($param_array['uida']);
		$ldapname=trim($param_array['ldapname']);
		$action=trim($param_array['action']);
		$urn_value=unserialize(base64_decode($param_array['old_urn_value']));
		
		if($_POST['add_new_attribute']){
			$priv_value=trim($_POST['new_value']);
		} else {
			$priv_value=base64_decode($param_array['privilege_value']);
		}
		
		if($this->debug){
			print "change_admin_privilege:\n";
			print "uid:$uid\n";
			print "ldapname:$ldapname\n";
			print "action:$action\n";
			print "privilege value:$priv_value\n";
			print "urn value:\n";
			print_r($urn_value);
		}
		
		if($uid){
			if($schema=load_schema()){
				if($ldapname && isset($schema->attribute[$ldapname]) && in_array ($ldapname, $attrs)){
					if(in_array ($action, $actions)){
						if($priv_value && $priv_value!=''){
							if($schema->attribute[$ldapname]->type=='vocabulary' && !isset($schema->attribute[$ldapname]->vocabulary[$priv_value])){
								$this->message=m(38) . " " . m(88);
								return false;
							} else {
								switch ($action){
									case 'add_privilege':
										if(is_array($urn_value[$ldapname])){
											if(!in_array($priv_value,$urn_value[$ldapname])){
												array_push($urn_value[$ldapname],$priv_value);
												$change=true;
											}
										} else {
											$urn_value[$ldapname]=array($priv_value);
											$change=true;
										}
									break;
									case 'revoke_privilege':
										if(is_array($urn_value[$ldapname])){
											$key=array_search($priv_value,$urn_value[$ldapname]);
											if($key===false){
												//ne postoji ta privilegija
											} else {
												unset($urn_value[$ldapname][$key]);
												$change=true;
											}
										}
									break;
								}
								if($change){
									$urn=$this->make_urn($urn_value);
									$this->revoke_admin_privileges($uid);
									
									$attr_array=array("uid=$uid," . BASE_DN => array('hrEduPersonRole'=>$urn));
									$req = new Ldap_request();
									if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapAddAttribute',$attr_array,true)){
										$this->message=m(89);
										$this->message.=$res['result'][$dn]['plugin_message'];
										return true;
									} else {
										if($this->debug){
											print "result:\n";
											print_r($req->get_result());						
										}
										$this->result=$req->get_result();
										$this->message.=$this->result[$dn]['message'];
										$this->message.=$this->result[$dn]['plugin_message'];
										$this->message.="<br>" . $req->get_message();
										return false;
									}
								} else {
									$this->message=m(19);
									return false;
								}
							}
						} else {
							$this->message=m(38) . " " . m(88);
							return false;
						}
					} else {
						$this->message=m(19);
						return false;
					}
				} else {
					$this->message=m(20) . " $ldapname " . m(72);
					return false;
				}
			} else {
				$this->message=m(0);
				return false;
			}
		} else {
			$this->message=m(18);
			return false;
		}
		
		
	}
	
	function revoke_admin_privileges($uid){
		$uid=trim($uid);
		if($uid){
			if($uid!=$_SESSION['uid']){
				$user_data=$this->get_user_data($uid,'hrEduPersonRole');
				if($this->debug){
					print "user data:\n";
					print_r($user_data);
				}
				if(is_array($user_data)){
					$dn="uid=$uid," . BASE_DN;
					$values=$user_data[$dn]['hrEduPersonRole'];
					if(!is_array($values)){
						$values=array($values);
					}
					if($this->debug){
						print "values:\n";
						print_r($values);
					}
					foreach ($values as $key=>$val) {
						$pos=strpos($val, 'administrator imenika');
						if($pos===false){
							//nije nadjen
						} else {
							$matches[]=$val;
						}
					}
					if($this->debug){
						print "matches:\n";
						print_r($matches);
					}
					if(is_array($matches)){
						$req=new Ldap_request();
						foreach ($matches as $val){
							$ok=true;
							$del_array[$dn]=array('hrEduPersonRole'=>$val);
							if($this->debug){
								print "del array:\n";
								print_r($del_array);
							}
							if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapDeleteAttribute',$del_array,true)){
								if($this->debug){
									print "obrisano\n";
								}
								$this->message.=$res['result'][$dn]['plugin_message'];
							} else {
								if($this->debug){
									print "result:\n";
									print_r($req->get_result());						
								}
								$this->result=$req->get_result();
								$this->message.=$this->result[$dn]['message'];
								$this->message.=$this->result[$dn]['plugin_message'];
								$ok=false;
							}
							
						}
						if($ok){
							$this->message.=m(86) . " $uid.";
						}
						return $ok;					
					} else {
						$this->message=m(85);
						return false;
					}
				} else {
					$this->message=m(38) . " " . m(81);
					return false;
				}
			} else {
				$this->message=m(38) . ": " . m(91);
				return false;
			}
		} else {
			$this->message=m(18);
			return false;
		}
	}
	
	function get_uploaded_data($type='add_new'){
		if($type=='add_new'){
			$add_new=true;
		} else {
			$add_new=false;
		}
		if($file=$this->get_uploaded_file('datoteka')){
			$delimiter=substr(trim($_POST['delimiter']),0,1);
			$encoding=trim($_POST['encoding']);
			if($encoding!='WINDOWS-1250' && $encoding!='ISO-8859-2' && $encoding!='UTF-8'){
				$encoding='WINDOWS-1250';
			}
			if(strlen($delimiter)<1){
				$this->message=m(38) . ": " . m(69);
				return false;
			} else {
				if(is_array($file)){
					$schema=load_schema();
					$header=trim(array_shift($file));
					$header=ltrim($header,"\xef\xbb\xbf\xff\xfe");
					$attributes=explode($delimiter,$header);
					if($this->debug){
						print "header: $header\n";
						print "atributi:";
						var_dump($attributes);
						print "\n";
					}
					if(is_array($attributes)){
						$col_no=count($attributes);
						$ok=true;
						foreach ($attributes as $key=>$val){
							if(!isset($schema->attribute[$val])){
								$ok=false;
								$this->message .= m(20) . " $val " . m(72) . "<br>";
							}
						}
						if($type=='add_new'){
							foreach ($this->obligatory_attr as $key=>$val){
								if(!(array_search($val,$attributes)>=0)){
									$ok=false;
									$this->message .= m(73) . " $val " . m(74) . "<br>";
								}
							}
						} else {
							if(!(array_search('uid',$attributes)>=0)){
								$ok=false;
								$this->message .= m(73) . " uid " . m(74) . "<br>";
							}
						}
						if(!$ok){
							$this->message= " " . m(38) . ": " . m(71) . $this->message;
							return false;
						} else {
							$row_no=1;
							foreach ($file as $key=>$line){
								$row_no++;
								$line=trim($line);
								if($line){
									$data=explode($delimiter,$line);
									if(!is_array($data) || count($data)!=$col_no){
										$ok=false;
										$this->message.="<br> " . m(75) . " $row_no: " . m(76);
									} else {
										$row_ok=true;
										$attr_array=array();
										foreach ($data as $col=>$value){
											if($encoding!='UTF-8' && gettype($value)=='string'){
												$value=iconv($encoding,'UTF-8',$value);
											}
											
											if($type=='change' && $attributes[$col]=='uid'){
												$attr_array['uid']=$value;
											} else {
												if($schema->attribute[$attributes[$col]]->validate($value,'admin',$add_new)){
													if($pom=$this->conv_attr_value($attributes[$col],$value,$schema->attribute[$attributes[$col]]->type)){
														$attr_array[$attributes[$col]]=$pom;
													}
												} else {
													$this->message.= m(75) . " $row_no: " . $schema->attribute[$attributes[$col]]->get_message() . "<br> ";
													$schema->attribute[$attributes[$col]]->message='';
													$ok=false;
													$row_ok=false;
												}
											}
											
										}
										if($this->debug){
											print "\nredak prije:";
											var_dump($attr_array);
											print "\n";
										}
										if($row_ok){
											if($type=='add_new'){
												foreach ($this->forbidden_attr as $v){
													unset($attr_array[$v]);
												}
												$attr_array['cn']=$attr_array['givenName'] . " " . $attr_array['sn'];
											}
											$dn="uid=" . $attr_array['uid']. "," . BASE_DN;
											if($type=='change'){
												unset($attr_array['uid']);
											}
											$attr_array_dn[$dn]=$attr_array;
										}
									}
								}
							}
							if($this->debug){
								print "\nattr_array:";
								var_dump($attr_array_dn);
								print "\n";
							}
							return $attr_array_dn;
						}
					} else {
						$this->message=m(38) . ": " . m(71);
						return false;
					}
				} else {
					$this->message=m(38) . ": " . m(41);
					return false;
				}
			}
		} else {
			return false;
		}
		
	}
	
	function upload_users($type='add_new'){
		switch($type){
			case 'add_new':
				$method='ldapAddUserLE';
				$err_mess=m(70);
				break;
			default:
				$method='ldapModifyAttribute';
				$err_mess=m(77);
		}
		if($attr_array_dn=$this->get_uploaded_data($type)){
			$req=new Ldap_request();
			if(is_array($attr_array_dn)){
				$res=$req->request($_SESSION['uid'],$_SESSION['password'],$method,$attr_array_dn,true);
				$this->result=$req->get_result();
				$this->message.= "\n" . $req->get_message();
				
				if($this->debug){
					print "rezultat:\n";
					print_r($this->result);
					print "message:\n";
					print_r($req->get_message());
				}
				
				if($res){
					return true;
				} else {
					return false;
				}
			} else {
				$this->message.=" " . $err_mess;
				return false;
			}
		} else {
			$this->message.=" " . $err_mess;
			return false;
		}
		
	}
	
	function get_result(){
		return $this->result;
	}
	
	function get_operation_result_html($message=false,$result=false,$succ_message){
		if($this->debug){
			print "\noperation result:\n";
			var_dump($result);
		}
			
		$upload_report_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$upload_report_tpl->set_file('upload_report', 'operation_result.html');
   	 	
   	 	$upload_report_tpl->set_block('upload_report','table_row_tpl','table_row');
   	 	$upload_report_tpl->set_block('upload_report','table_err_row_tpl','table_err_row');
   	 	$upload_report_tpl->set_var('MESSAGE',$message);
   	 	
   	 	if(is_array($result)){
   	 		$ok=0;
   	 		$err=0;
   	 		foreach ($result as $dn => $value) {
   	 			$upload_report_tpl->set_var('DN',$dn);
   	 			if($value['code']==0){
   	 				$ok++;
   	 				if($ok%2==1){
	   	 				$upload_report_tpl->set_var('ROW_CLASS','odd_row');
	   	 			} else {
	   	 				$upload_report_tpl->set_var('ROW_CLASS','even_row');
	   	 			}
   	 				$upload_report_tpl->set_var('RESULT','OK');
   	 				$upload_report_tpl->set_var('ERROR_MESSAGE',$succ_message . $value['plugin_message']);
   	 				$upload_report_tpl->parse('table_row','table_row_tpl',true);
   	 			} else {
   	 				$err++;
   	 				$upload_report_tpl->set_var('RESULT',m(38));
   	 				$upload_report_tpl->set_var('ERROR_MESSAGE',$value['message'] . $value['plugin_message']);
   	 				$upload_report_tpl->parse('table_err_row','table_err_row_tpl',true);
   	 			}
   	 		}
   	 		$upload_report_tpl->set_var('COUNT',$ok + $err);
   	 		$upload_report_tpl->set_var('COUNT_OK',$ok);
   	 		$upload_report_tpl->set_var('COUNT_ERR',$err);
   	 	} else {
   	 		$upload_report_tpl->set_var('COUNT','0');
   	 		$upload_report_tpl->set_var('COUNT_OK','0');
   	 		$upload_report_tpl->set_var('COUNT_ERR','0');
   	 	}	
   	 	
   	 	if(!$ok){
   	 		$upload_report_tpl->set_var('table_row','');
   	 	}
   	 	if(!$err){
   	 		$upload_report_tpl->set_var('table_err_row','');
   	 	}
   	 	$upload_report_tpl->parse('output', 'upload_report');	
		return $upload_report_tpl->get_var('output');
	}
	
	
	function get_uploaded_file($inputname){

		$remoteFile = $_FILES[$inputname]['name'];
		$fileType = $_FILES[$inputname]['type'];
		$fileSize = $_FILES[$inputname]['size'];
	
		$errMessages = array (
				m(37),
				m(38) . ": " . m(39),
				m(38) . ": " . m(39),
				m(38) . ": " . m(40),
				m(38) . ": " . m(41),
				m(38) . ": " . m(42),
				m(38) . ": " . m(43)
		);
	
		if (strlen($remoteFile) == 0) {
			$error = 5;	
		} elseif ($fileSize < 1) {
			$error = 6;
		} else $error = $_FILES[$inputname]['error'];
		
		if($error==0){
			return file($_FILES[$inputname]['tmp_name'], FILE_IGNORE_NEW_LINES);
		} else {
			$this->message=$errMessages[$error];
			return false;
		}
		
	}
	
	function get_chk_pwd_html($message=false,$image=false){
		
		$user_list_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$user_list_tpl->set_file('chk_pwd', 'chk_pwd.html');
		$user_list_tpl->set_block('chk_pwd','image_tpl','image');
		
   	 	$user_list_tpl->set_var('MESSAGE',$message);
   	 	$user_list_tpl->set_var('REALM',REALM);
   	 	
   	 	if($image){
   	 		$user_list_tpl->set_var('IMAGE_NAME',$image);
   	 		$user_list_tpl->parse('image','image_tpl');
   	 	} else {
   	 		$user_list_tpl->set_var('image','');
   	 	}
   	 	$user_list_tpl->parse('output', 'chk_pwd');	
		return $user_list_tpl->get_var('output');
	}
	
	function chk_pwd(){
		$uid=$_POST['uid'];
		$pwd=$_POST['password'];
		require_once(CLASS_INCLUDE_PATH . 'login/login.php');
		$login=new Login();
		if($uid && $uid!='' && $pwd && $pwd!=''){
			$pwd=base64_encode($pwd);
			if($login->autenticate_user($uid,$pwd)){
				$ok=true;
			}
		}
		if($ok){
			$this->message=m(51);
			$this->message.= " " . $login->get_message();
			$this->image="ok.gif";
		} else {
			$this->message=m(1);
			$this->message.= " " . $login->get_message();
			$this->image="no.gif";
		}
		return $ok;
	}
	
	function get_image(){
		return $this->image;	
	}
	
	function get_user_list($filter,$attributes,$from,$size){
		global $soap_params;
		if($this->debug){
			print "filter:$filter<br>atributi:$attributes<br>";
		}
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall('ldapList', array($_SESSION['uid'],$_SESSION['password'],BASE_DN,$filter,$attributes,$from,$size));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($result['code']===0){
			if($result['count']>0){
				$user_list['count']=$result['count'];
				$user_list['user_list']=xml_to_array($result['result']);
				return $user_list;
			} else {
				return array('count'=>0,'user_list'=>false);
			}
		} else {
			$this->message=$result['error'];
			return false;
		}
	}
	
	function get_ppolicy_list_html($message){
		global $soap_params;
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa 
			$result = $client->__soapCall('ldapLockAction', array($_SESSION['uid'],$_SESSION['password'],BASE_DN,1,null));	
			

		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				var_dump($result);
				var_dump($client);
				print "\n</pre>\n";
			}
			return false;
		}
		
		if($result['code']===0){
			$user_list=xml_to_array($result['result'],$utf8_decode_to);
		} else {
			$this->message=$result['error'];
		}
		$pp_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	$pp_tpl->set_file('ppolicy_list', 'ppolicy_list.html');
   	$pp_tpl->set_block('ppolicy_list','table_row_tpl','table_row');
		$pp_tpl->set_var('MESSAGE',$this->message);
		if(is_array($user_list)){
			$i=0;
			foreach($user_list as $k=>$v){
				$i++;
				list($uid,$realm,$hr)=explode(',',$k);
				list($hr,$uid)=explode('=',$uid);
				$pp_tpl->set_var('UID',$uid);
				$pp_tpl->set_var('ROW_CLASS',($i%2==1) ? 'odd_row' : 'even_row' );
				$pp_tpl->set_var('pwdExpireTime',str_replace(array('(CET)','(CEST)'),array('',''),$v['pwdExpireTime']));
				$pp_tpl->set_var('pwdGraceAuthN',$v['pwdGraceAuthN']);
				if($v['pwdLocked']=='true'){
					$pp_tpl->set_var('lclass',' style="color:red"');
					$pp_tpl->set_var('pwdLocked','Da');
				} else {
					$pp_tpl->set_var('lclass','');
					$pp_tpl->set_var('pwdLocked','Ne');
				}
				$pp_tpl->parse('table_row','table_row_tpl',true);
			}
		} else {
			$pp_tpl->set_var('table_row','Nema nijedan zaključan korisnik.');
		}
		$pp_tpl->parse('output', 'ppolicy_list');	
		return $pp_tpl->get_var('output');
		
	}
	
	function get_user_list_all($filter,$attributes,$utf8_decode_to=false){
		global $soap_params;
		if($this->debug){
			print "filter:$filter<br>atributi:$attributes<br>";
		}
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall('ldapSearch', array($_SESSION['uid'],$_SESSION['password'],BASE_DN,$filter,$attributes));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($this->debug){
	    print "result:";
			var_dump($result);
			print "\n";
		}
		if($result['code']===0){
			$user_list=xml_to_array($result['result'],$utf8_decode_to);
			return $user_list;
		} else {
			$this->message=$result['error'];
			return false;
		}
	}
	function get_add_attribute_html($param_array,$message=false){
		$uid=trim($param_array['uida']);
		if($param_array['show']=='add_privilege_form'){
			$attribute=trim($param_array['ldapname']);
			$urn_value=$param_array['old_urn_value'];
			$privilege=true;
		} else {
			$attribute=trim($param_array['attribute']);
		}
		if(!$attribute || !$uid){
			return join('',file(TPL_INCLUDE_PATH . 'error.html'));
		} else {
			if($schema=load_schema()){
				if(isset($schema->attribute[$attribute])){					
					return $schema->attribute[$attribute]->get_add_new_html($uid,$attribute,$param_array['attributes'],'admin',$message,$privilege,$urn_value);
				} else {
					return join('',file(TPL_INCLUDE_PATH . 'error.html'));
				}
			} else {
				return join('',file(TPL_INCLUDE_PATH . 'error.html'));
			}
		}	
	}
	
	function get_chg_pwd_form_html($param_array,$message=false){
		$uid=trim($param_array['uida']);
		$attributes=trim($param_array['attributes']);
		if($this->debug){
			print "param array:\n";
			print_r($param_array);
		}
		if(!$uid){
			return join('',file(TPL_INCLUDE_PATH . 'error.html'));
		} else {
			if($schema=load_schema()){
				if(isset($_POST['chg_pwd_button'])){
					$pwd=$_POST['new_password'];
				} else {
					$pwd=$schema->pwdgen();
				}
				$chg_pwd_form_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 			$chg_pwd_form_tpl->set_file('chg_pwd_form', 'chg_pwd_form.html');
				
   	 			$chg_pwd_form_tpl->set_var('OPIS',$schema->attribute['userPassword']->desc);
				$chg_pwd_form_tpl->set_var('NAZIV',$schema->attribute['userPassword']->name);
				$chg_pwd_form_tpl->set_var('LDAPNAZIV',$schema->attribute['userPassword']->ldapname);
				$chg_pwd_form_tpl->set_var('MESSAGE',$message);
				$chg_pwd_form_tpl->set_var('FORM_ACTION','index.php?action=chg_pwd&template=new_attribute&attributes=' . $attributes . '&uida=' . $uid);
				$chg_pwd_form_tpl->set_var('VRIJEDNOST',$pwd);
				
				$chg_pwd_form_tpl->parse('output', 'chg_pwd_form');	
				return $chg_pwd_form_tpl->get_var('output');
				
			} else {
				return join('',file(TPL_INCLUDE_PATH . 'error.html'));
			}
		}	
	}
	
	function chg_pwd($param_array){
		$uid=trim($param_array['uida']);
		if(!$uid){
			$this->message=m(18);
			return false;
		} else {
			$npwd=trim($_POST['new_password']);
			list($ok,$message)=chk_password_strength($npwd,$uid);
			if($ok){
				$hash_pwd=$this->conv_attr_value('userPassword',$npwd);
				$dn="uid=$uid," . BASE_DN;
				$attr_array=array($dn=>array('userPassword'=>$hash_pwd));
				$req=new Ldap_request();
				$res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapModifyAttribute',$attr_array,true);
				$this->result=$req->get_result();
			//	var_dump($this->result);
				if($res){
					if($uid==$_SESSION['uid']){
						$_SESSION['password']=base64_encode($npwd);
					}
					$this->new_password=$npwd;
					$this->message=m(9);
					$this->message.=$this->result[$dn]['plugin_message'];
					return true;
				} else {
					$this->message=$this->result[$dn]['message'];
					$this->message.=$this->result[$dn]['plugin_message'];
					$this->message.="<br>" . $req->get_message();
					return false;
				}
			} else {
				$this->message=$message;
				return false;
			}
		}	
	}
	
	function get_new_user_html($message=false,$post_array=false){		
		if($schema=load_schema()){
			$schema->attribute['userPassword']->view['admin']='true';
			if(isset($post_array['add_new'])){
				$all_attrs=array_merge($this->obligatory_attr,$this->non_obligatory_attr);
				foreach($all_attrs as $ldapname){
					if(isset($post_array[$ldapname]) && trim($post_array[$ldapname])!=''){
						$value=$post_array[$ldapname];
						
						if(isset($post_array[$ldapname . '_prefix'])){
							if(is_array($value)){
								$pref=$post_array[$ldapname . '_prefix'];
								foreach ($value as $key=>$val) {
									$value[$key]=trim($pref[$key]) . ': ' . $val;
								}
							} else {
								$value=trim($post_array[$ldapname . '_prefix']) . ': ' . $value;
							}
						}
						$schema->attribute[$ldapname]->value=$value;
					}
				}	
			}
			$schema->make_new_html($message);
			return $schema->get_html();
		} else {
			return join('',file(TPL_INCLUDE_PATH . 'error.html'));
		}
			
	}
	
	function get_edit_user_html($uid,$type='all',$message=false,$post_arr=false,$new_password=false){		
		if($schema=load_schema()){
			$pom=$this->get_user_data($uid);
			//$pom=$this->get_user_data($uid,null,false,true);
			$userdata=$pom["uid=$uid," . BASE_DN];
			if(is_array($userdata)){
				//u vocabulary primary affiliationa treba staviti samo vrijednosti affiliationa.
				$aff=$userdata['hrEduPersonAffiliation'];
				if(!is_array($aff)){
					$aff=array($aff);
					
				} 
				foreach ($aff as $val) {
					$affiliation[$val]=$schema->attribute['hrEduPersonPrimaryAffiliation']->vocabulary[$val];
				}
				$schema->attribute['hrEduPersonPrimaryAffiliation']->vocabulary=$affiliation;
				if($this->debug){
					print "user data:\n";
					print_r($userdata);
					print "\naffiliation:\n";
					print_r($affiliation);
					print "\nschema-primaryAffiliation:\n";
					print_r($schema->attribute['hrEduPersonPrimaryAffiliation']->vocabulary);
				}
				
				foreach($schema->attribute as $key=>$attr){
					if(($type=='must' && $attr->must=='true') || $type=='all'){
						if(is_array($userdata[$attr->ldapname])){
							//print_r($userdata[$attr->ldapname]);
							foreach ($userdata[$attr->ldapname] as $k => $v) {
								if(trim($v)!=''){
									$ok=true;
								}							
							}
							if($ok){
								$schema->attribute[$key]->set_value($userdata[$attr->ldapname]);
							}
						} else {
							if(isset($userdata[$attr->ldapname]) && trim($userdata[$attr->ldapname])!=''){
								$schema->attribute[$key]->set_value($userdata[$attr->ldapname]);
							}
						}
					}
				}
				$schema->make_html($type,$message,'admin',$new_password);
				$html=$schema->get_html();
				$schema->unset_html();
				$_SESSION['schema']=serialize($schema);
			} else {
				return join('',file(TPL_INCLUDE_PATH . 'error.html'));
			}
			return $html;
		} else {
			return join('',file(TPL_INCLUDE_PATH . 'error.html'));
		}
			
	}
	
	function get_user_data($uid,$attributes=null,$anonymus=false,$ppolicy=false){
		global $soap_params;
		/*if($attributes===null && $ppolicy){
			$attributes='*,pwdPolicySubentry,pwdGraceUseTime';
		} elseif ($ppolicy){
			$attributes.=',pwdPolicySubentry,pwdGraceUseTime';
		}*/

		if($this->debug){
			print "<pre>attributes:" . $attributes . "</pre>\n";
		}
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			if($anonymus){
				if($this->debug){
					print "anonSearch\n";
				}
				$result = $client->__soapCall('anonSearch', array(BASE_DN,"(uid=$uid)",$attributes));	
			} else {
				if($this->debug){
					print "ldapSearch\n";
				}
				$result = $client->__soapCall('ldapSearch', array($_SESSION['uid'],$_SESSION['password'],BASE_DN,"(uid=$uid)",$attributes));	
			}
			
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		
		if($this->debug){
			print "code:" . $result['code'] ."\n";
			print "<pre>result:\n";
			print $result['result'];
			var_dump($client);
			print "\n</pre>\n";
		}
		if($result['code']===0){
			return xml_to_array($result['result']);
		} else {
			$this->result=xml_to_array($result['result']);
			$this->message.= $this->result["uid=$uid," . BASE_DN]['message'];
			$this->message.= $this->result["uid=$uid," . BASE_DN]['plugin_message'];
			$this->message.= '<br>' . $result['error'];
			return false;
		}
		
	}
	
	function add_attribute($param_array){
		$uid=trim($param_array['uida']);
		$ldapname=trim($param_array['attribute']);
		
		if($uid){
			if($ldapname){
				$dn="uid=$uid," . BASE_DN;
				$newschema=load_schema();
				$oldschema=unserialize($_SESSION['schema']);
				if($oldschema){
					$ok=true;
					if(isset($oldschema->attribute[$ldapname]->value) && @count($oldschema->attribute[$ldapname]->value)>0 && $oldschema->attribute[$ldapname]->multiple=='false'){
						$this->message.=m(20) . " $ldapname " . m(21);
						$ok=false;
					} else {
						if($newschema->attribute[$ldapname]->type=='binary'){
							$binary=new Binary();
							if($attr_array[$dn][$ldapname]=$binary->get_uploaded_attribute_value("new_value")){
							} else {
								$this->message.=$binary->get_message();
								$ok=false;
							}
						} else {
							
							$value=trim($_POST['new_value']);
							if(isset($_POST['new_value_prefix']) && trim($_POST['new_value_prefix'])!=''){
								$value=trim($_POST['new_value_prefix']) . ': ' . $value;
							}
							if($newschema->attribute[$ldapname]->validate($value,'admin')){
								if($pom=$this->conv_attr_value($ldapname,$value,$newschema->attribute[$ldapname]->type)){
									$attr_array[$dn][$ldapname]=$pom;
								}
							} else {
								if($this->debug){
									print "Msg:";
									var_dump($newschema);
									print "\n<br>";
								}
								$this->message.=$newschema->attribute[$ldapname]->get_message();
								$ok=false;
							}
						}
					}
					if(is_array($attr_array) && $ok){
						$req=new Ldap_request();
						if($this->debug){
							print "add: ";
							var_dump($attr_array);
							print "\n";
						}
						if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapAddAttribute',$attr_array,true)){
							$this->message=m(20) . " $ldapname " . m(22);
							$this->message.=$res['result'][$dn]['plugin_message'];
							return true;
						} else {
							if($this->debug){
								print "result:\n";
								print_r($req->get_result());						
							}
							$this->result=$req->get_result();
							$this->message=$this->result[$dn]['message'];
							$this->message.=$this->result[$dn]['plugin_message'];
							$this->message.="<br>" . $req->get_message();
							return false;
						}
					} else {
						return false;
					}
				} else {
					$this->message=m(19);
					return false;
				}
			} else {
				$this->message=m(19);
				return false;
			}
		} else {
			$this->message=m(18);
			return false;
		}
	}
	
	function chg_user($post_array,$uid,$type='all'){
		if($uid){
			if($this->debug){
				print "post_array:\n";
				print_r($post_array);
			}
			$dn="uid=$uid," . BASE_DN;
			$newschema=load_schema();
			$oldschema=unserialize($_SESSION['schema']);
			if($oldschema){
				$binary=new Binary();
				// promjena vrijednosti atributa
				$ok=true;				
				foreach ($post_array as $ldapname => $attrvalue) {
					if(isset($newschema->attribute[$ldapname])){
						$attr=$newschema->attribute[$ldapname];
						if(is_array($attrvalue)){
							foreach ($attrvalue as $k => $v){
								if($v==''){
									unset($attrvalue[$k]);
								}
							} 
						}
						if(isset($post_array[$ldapname . '_prefix'])){
							$pref=$post_array[$ldapname . '_prefix'];
							if(is_array($attrvalue)){
								foreach ($attrvalue as $k => $v){
									if($v!=''){
										$attrvalue[$k]=$pref[$k] . ': ' .$attrvalue[$k];
									}
								} 
							} else {
								if($attrvalue!=''){
									$attrvalue=$pref . ': ' .$attrvalue;
								}
							}
							if($this->debug){
								print "attrvalue:\n";
								print_r($attrvalue);
							}
						}
						if($this->debug){
							print "\n" . $ldapname . " staro:" .  $oldschema->attribute[$ldapname]->value . ", novo: $attrvalue";
						}
						if(($attrvalue==0 && $oldschema->attribute[$ldapname]->value!=0) || $oldschema->attribute[$ldapname]->value!=$attrvalue){
							if($this->debug){
								print "razliciti\n<br>";
								print "<br><br>tip:$type<br>ldapname:$ldapname<br>";
								print "staro:";
								print_r($oldschema->attribute[$ldapname]->value);
								print "<br>novo:";
								print_r($attrvalue);
							}
	
							if(($attr->must=='true' && $type=='must') || $type=='all'){
								if($attr->validate($attrvalue,'admin')){
									if (isset($attrvalue)) {
										if(is_array($attrvalue)){
											foreach ($attrvalue as $key=>$val) {
												$pom=$this->conv_attr_value($ldapname,$val,$attr->type);
												if($pom===0 || $pom==='0' || $pom){
													$attr_array[$dn][$ldapname][$key]=$pom;
												}
											}
										} else {
											$pom=$this->conv_attr_value($ldapname,$attrvalue,$attr->type);										
											if($pom===0 || $pom==='0' || $pom){
												$attr_array[$dn][$ldapname]=$pom;
											} else {
												$del_attr_array[$dn][$ldapname]='';
											}
										}
									}
								} else {
									$ok=false;
									$this->message.=$attr->get_message();
								}
							}
						}
					}
				}
				if($ok){
					$req=new Ldap_request();
					if(is_array($attr_array)){
						
						if($this->debug){
							print "chg: ";
							var_dump($attr_array);
							print "\n";							
							print "del:";
							var_dump($del_attr_array);
							print "\n";
						}
						if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapModifyAttribute',$attr_array,true)){
							//$this->message="Podaci o korisniku a�urirani.";
							//return true;
							$this->message.=$res['result'][$dn]['plugin_message'];
						} else {
							if($this->debug){
								print "result:\n";
								print_r($req->get_result());						
							}
							$this->result=$req->get_result();
							$this->message=$this->result[$dn]['message'];
							$this->message.=$this->result[$dn]['plugin_message'];
							$this->message.="<br>" . $req->get_message();
							$ok=false;
						}
					}
					if(is_array($del_attr_array) && $ok){
						if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapDeleteAttribute',$del_attr_array,true)){
							//$this->message="Podaci o korisniku a�urirani.";
							//return true;
							$this->message.=$res['result'][$dn]['plugin_message'];
						} else {
							if($this->debug){
								print "result:\n";
								print_r($req->get_result());						
							}
							$this->result=$req->get_result();
							$this->message=$this->result[$dn]['message'];
							$this->message.=$this->result[$dn]['plugin_message'];
							$this->message.="<br>" . $req->get_message();
							$ok=false;
						}
					}
					if($ok){
						$this->message.=" " . m(79);
					}
					return $ok;
				} else {
					return false;
				}
			} else {
				$this->message=m(19);
				return false;
			}
		} else {
			$this->message=m(18);
			return false;
		}
	}
	
	
	
	function get_upload_form_html($message=false){		
		$upload_form_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$upload_form_tpl->set_file('upload_form', 'upload_form.html');

   	 	$upload_form_tpl->set_var('MESSAGE',$message);
   	 	
   	 	$upload_form_tpl->parse('output', 'upload_form');	
		return $upload_form_tpl->get_var('output');
	}
	
	function get_upload_ch_form_html($message=false){		
		$upload_form_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$upload_form_tpl->set_file('upload_form', 'upload_changes_form.html');

   	 	$upload_form_tpl->set_var('MESSAGE',$message);
   	 	
   	 	$upload_form_tpl->parse('output', 'upload_form');	
		return $upload_form_tpl->get_var('output');
	}
	
	function get_upload_del_form_html($message=false){		
		$upload_form_tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
   	 	$upload_form_tpl->set_file('upload_form', 'upload_delete_form.html');

   	 	$upload_form_tpl->set_var('MESSAGE',$message);
   	 	
   	 	$upload_form_tpl->parse('output', 'upload_form');	
		return $upload_form_tpl->get_var('output');
	}
	
	function extend_users(){
		
		$datum=trim($_POST['extend_date']);
		
		$schema=load_schema();
		
		if($schema->attribute['hrEduPersonExpireDate']->check_value($datum)){
			$uids=$this->get_selected_uids();
			$datum=conv_date_to_ldap($datum);
			if(is_array($uids)){
				$ok=true;
				$this->message='';
				foreach ($uids as $uid) {
					$attr_array_dn['uid=' . $uid .',' . BASE_DN]=array('hrEduPersonExpireDate'=>$datum);
				}
				$req=new Ldap_request();
				$res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapModifyAttribute',$attr_array_dn,true);
				$this->result=$req->get_result();
			//	var_dump($this->result);
				if($res){
					$this->message=m(64);
					return true;
				} else {
					$this->message.= "<br>" . $req->get_message();
					return false;
				}
			} else {
				$this->message=m(61);
				return false;
			}	
		} else {
			$this->message=ucfirst(m(33));
			return false;
		}
	}
	
	function delete_users($upload_file=false){
		if($upload_file){
			$uids=$this->get_uploaded_file('datoteka');
			if(is_array($uids)){
				$uids[0]=ltrim($uids[0],"\xef\xbb\xbf\xff\xfe");
			}
		} else {
			$uids=$this->get_selected_uids();
		}
		if(is_array($uids)){
			$ok=true;
			$this->message='';
			foreach ($uids as $uid) {
				$attr_array_dn['uid=' . trim($uid) .',' . BASE_DN]=1;
			}
		}
		if(is_array($attr_array_dn)){
			$req=new Ldap_request();
			$res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapDeleteUser',$attr_array_dn,true);
			$this->result=$req->get_result();
		//	var_dump($this->result);
			if($res){
				$this->message=m(62);
				return true;
			} else {
				$this->message.= "\n" . $req->get_message();
				return false;
			}
		} else {
			$this->message=m(61);
			return false;
		}
	}
	
	function delete_user($uid=false){
		if($uid){
			$attr_array_dn['uid=' . $uid .',' . BASE_DN]=1;
			$req=new Ldap_request();
			if($result=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapDeleteUser',$attr_array_dn,true)){
				$this->message=m(63);
				$this->message.=$result['result']["uid=$uid," . BASE_DN]['plugin_message'];
				return true;
			} else {
				if($this->debug){
					if($this->debug){
						print "result:\n";
						print_r($req->get_result());						
					}
				}
				$err_des_array=$req->get_result();
				$this->message=$req->get_message();
				$this->message.= " " . $err_des_array['uid=' . $uid .',' . BASE_DN]['message'];
				$this->message.= " " . $err_des_array['uid=' . $uid .',' . BASE_DN]['plugin_message'];
				return false;
			}
		} else {
			$this->message=m(61);
			return false;
		}
	}
	
	function conv_attr_value($ldapname,$attrvalue=false,$type=false){
		if(!$type){
			$type=0;
		}
		if(isset($attrvalue) && trim($attrvalue)!=''){
		#	print "$ldapname: nije prazan\n<br>";
			if($_SESSION['admintype']==3 && $ldapname=='hrEduPersonRole' && $attrvalue=='administrator imenika'){
				$retvalue=$this->make_urn($this->get_admin_privileges());
			} /*elseif($ldapname=='userPassword'){
				$retvalue='{SHA}' . base64_encode(pack("H*",sha1($attrvalue)));			
			} */
			elseif ($type==='binary'){
				//$retvalue=base64_encode($attrvalue);
				$retvalue=$attrvalue;
			} elseif ($type==='date') {
				$retvalue=conv_date_to_ldap(trim($attrvalue));
			} elseif ($ldapname=='uid') {
				$retvalue=strtolower(trim($attrvalue));
			} else {
				$retvalue=trim($attrvalue);	
			}
			return $retvalue;
		} else {
			return false;
		}
	}
		
	function add_new(){
		$post_array=$_POST;
		if($post_array && is_array($post_array)){
			$schema=load_schema();
			$ok=true;
			$all_attr=array_merge($this->obligatory_attr,$this->non_obligatory_attr);
			foreach ($all_attr as $ldapname) {
				if(isset($post_array[$ldapname])){
					if(is_array($post_array[$ldapname])){
						$value=array_shift($post_array[$ldapname]);
						if(isset($post_array[$ldapname . '_prefix'])){
							$value=trim(array_shift($post_array[$ldapname . '_prefix'])) . ': ' . $value;
						}
					} else {
						$value=$post_array[$ldapname];
						if(isset($post_array[$ldapname . '_prefix'])){
							$value=trim($post_array[$ldapname . '_prefix']) . ': ' . $value;
						}
					}
					
					$attr=$schema->attribute[$ldapname];
					if($attr->validate($value,'admin',true)){
						if (isset($value) && $value!='') {
							if($ldapname=='userPassword'){
								$new_password=$value;
							}
							if($pom=$this->conv_attr_value($ldapname,$value,$attr->type)){
								$attr_array[$ldapname]=$pom;
							}
						}
					} else {
						$ok=false;
						$this->message.=$attr->get_message() . "<br>";
					}
				} else {
					if(array_search($ldapname,$this->obligatory_attr)>=0){
						$ok=false;
						$this->message.=m(66) . " $ldapname.";
					}
				}
				
			}
			if($ok){
				$attr_array['cn']=$attr_array['givenName'] . " " . $attr_array['sn'];
				$uid=$attr_array['uid'];
				$dn="uid=$uid," . BASE_DN;
				$attr_array_dn[$dn]=$attr_array;
				$req=new Ldap_request();
				if($this->debug){
					print "attr_array:\n";
					print_r($attr_array);						
				}
				if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapAddUserLE',$attr_array_dn,true)){
					$this->message=m(67) . " $uid " . m(22);
					$this->message.=$res['result'][$dn]['plugin_message'];
					$this->new_password=$new_password;
					return $uid;
				} else {
					if($this->debug){
						print "result:\n";
						print_r($req->get_result());						
					}
					$pom_mess=array_shift($req->get_result());
					$this->message=$pom_mess['message'] . "<br>" . $pom_mess['plugin_message'] . "<br>" . $req->get_message();
					return false;
				}
			} else {
				$this->message.=m(67) .  " " . m(68);
				return false;	
			}
		} else {
			$this->message=m(38) . ". " . m(67) .  " " . m(68);
			return false;
		}
	}
	
	function delete_attribute($uid,$ldapname){
		$ok=true;
		$ldapname=trim($ldapname);
		$schema=unserialize($_SESSION['schema']);
		if($schema){
			if($schema->attribute[$ldapname]->change[$_SESSION['usertype']]=='false'){
				$this->message.=m(35) . " $ldapname.";
				return false;
			} else {
				if(preg_match('/\[(\d*)\]$/',$ldapname,$matches)){
					if(((is_array($schema->attribute[$ldapname]->value) && count($schema->attribute[$ldapname]->value)<2) || !is_array($schema->attribute[$ldapname]->value)) && $schema->attribute[$ldapname]->must=='true'){
						$this->message.=" " .m(20) . " $ldapname " . m(44);
						$ok=false;
					} else {
						$key=$matches[1];
						$ldapname=substr($ldapname,0,-1*(2+strlen($key)));
						$del_array["uid=$uid," . BASE_DN]=array($ldapname=>$this->conv_attr_value($ldapname,$schema->attribute[$ldapname]->value[$key],$schema->attribute[$ldapname]->type));
					}
				} else {
					if($schema->attribute[$ldapname]->must=='true'){
						$this->message.=" " . m(20) . " $ldapname " . m(44);
						$ok=false;
					} else {
						$del_array["uid=$uid," . BASE_DN]=array($ldapname=>'');
					}
				}
				if($del_array && $ok){
					$req=new Ldap_request();
					if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapDeleteAttribute',$del_array,true)){
						$this->message=m(20) . " $ldapname " . m(45);
						$this->message.=$res['result']["uid=$uid," . BASE_DN]['plugin_message'];
						return true;
					} else {
						if($this->debug){
							print "result:\n";
							print_r($req);						
						}
						$this->result=$req->get_result();
						$this->message=$this->result["uid=$uid," . BASE_DN]['message'];
						$this->message.=$this->result["uid=$uid," . BASE_DN]['plugin_message'];
						$this->message.="<br>" . $req->get_message();
						return false;
					}
				}
			}
		} else {
			$this->message.= " $ldapname: " . m(46);
			return false;
		}
		
	}
	
	function get_certify_html(){
		$this->ispravi_oib();
		global $soap_params;
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall('ldapCertData', array($_SESSION['uid'],$_SESSION['password'],BASE_DN));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($this->debug){
	    print "result:";
			var_dump($result);
			print "\n";
		}
		if($result['code']===0){
			$r=xml_to_array($result['result']);
			$ret=nl2br(base64_decode($r["uid=" . $_SESSION['uid'] . "," . BASE_DN]['cert_data']));
			$ret=str_replace(array('---detaljne informacije---','Podaci o ustanovi:'),array('<br><hr><br><b>Zbirni podaci:</b>','<hr><br><b>Podaci o ustanovi:</b><br>'),$ret);
			$ret="<b>Pronadjeni problemi:</b><br><br>" . $ret;
		} else {
			$message=$result['error'];
		}
		$tpl = new Template(CLASS_INCLUDE_PATH . "admin/tpl/", 'comment');
 	 	$tpl->set_file('frame', 'certify.html');
 	 	$tpl->set_var('MESSAGE',$message);
		$tpl->set_var('certify',$ret); 	 	
 	 	return $tpl->parse('output', 'frame');	
	}
	
	function ispravi_oib(){
		global $soap_params;
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall('ldapSearch', array($_SESSION['uid'],$_SESSION['password'],BASE_DN,'(&(uid=*)(!(hrEduPersonUniqueNumber=*OIB*))(!(hrEduPersonOIB=NONE)))', 'hrEduPersonOIB'));
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($this->debug){
	    print "result:";
			var_dump($result);
			print "\n";
		}
		if($result['code']===0){
			$r=xml_to_array($result['result']);
			if(is_countable($r) && count($r)>0){
				foreach($r as $dn=>$val){
					$xml_update.='<entry dn="' . $dn . '"><attribute ldapname="hrEduPersonUniqueNumber"><value>OIB: ' . $val['hrEduPersonOIB'] . '</value></attribute></entry>';
				}
				try {
					$client = new SoapClient(null,$soap_params);
					// poziv metode web servisa
					$result = $client->__soapCall('ldapAddAttribute', array($_SESSION['uid'],$_SESSION['password'],BASE_DN,'<ldap>' .$xml_update. '</ldap>'));
				} catch (Exception $e) {
					//greska u komunikaciji
					$this->message=$e -> getMessage ();
					if($this->debug){
						print "<pre>SOAP ERROR:\nmessage:" . $this->message;
						print "\n</pre>\n";
					}
					return false;
				}
				if($this->debug){
					print "xml_update:$xml_update\n";
			    print "result:";
					var_dump($result);
					print "\n";
				}
			}
		} else {
			$this->message=$result['error'];
		}
		
	}
	
	
	function get_message(){
		return $this->message;
	}
}


?>
