<?PHP

class User{
	
	var $message;
	var $debug=false;
	var $result;
	
	function get_edit_user_html($type="all",$message=false,$post_arr=false){
		if(!$type){
			$type='all';
		}
		if($schema=load_schema()){
			$pom=$this->get_user_data($_SESSION['uid']);
			$userdata=$pom['uid=' . $_SESSION['uid']. ',' . BASE_DN];    
			    
			foreach($schema->attribute as $key=>$attr){
				if(($type=='must' && $attr->must=='true') || $type=='all'){
					if(is_array($userdata[$attr->ldapname])){
						foreach ($userdata[$attr->ldapname] as $k => $v) {
							if(trim($v)!=''){
								$ok=true;
							}							
						}
						if($ok){
							$schema->attribute[$key]->set_value($userdata[$attr->ldapname]);
						}
					} else {
						if(isset($userdata[$attr->ldapname]) && trim($userdata[$attr->ldapname])!=''){
							$schema->attribute[$key]->set_value($userdata[$attr->ldapname]);
						}
					}
				}
			}
			$schema->make_html($type,$message,'user');
			$html=$schema->get_html();
			$schema->unset_html();
			$_SESSION['schema']=serialize($schema);
			
			return $html;
		} else {
			return join('',file(TPL_INCLUDE_PATH . 'error.html'));
		}	
	}
	
	function get_add_attribute_html($param_array,$message=false){
		$uid=$_SESSION['uid'];
		$attribute=trim($param_array['attribute']);
		if(!$attribute){
			return join('',file(TPL_INCLUDE_PATH . 'error.html'));
		} else {
			if($schema=load_schema()){
				if(isset($schema->attribute[$attribute])){					
					return $schema->attribute[$attribute]->get_add_new_html($uid,$attribute,$param_array['attributes'],'user',$message);
				} else {
					return join('',file(TPL_INCLUDE_PATH . 'error.html'));
				}
			} else {
				return join('',file(TPL_INCLUDE_PATH . 'error.html'));
			}
		}	
	}
	
	function add_attribute($param_array){
		$uid=$_SESSION['uid'];
		$ldapname=trim($param_array['attribute']);
		
		if($uid){
			if($ldapname){
				$dn="uid=$uid," . BASE_DN;
				$newschema=load_schema();
				$oldschema=unserialize($_SESSION['schema']);
				if($oldschema){
					$ok=true;
					if(isset($oldschema->attribute[$ldapname]->value) && @count($oldschema->attribute[$ldapname]->value)>0 && $oldschema->attribute[$ldapname]->multiple=='false'){
						$this->message.=m(20) . " $ldapname " . m(21);
						$ok=false;
					} else {
						if($newschema->attribute[$ldapname]->type=='binary'){
							$binary=new Binary();
							if($attr_array[$dn][$ldapname]=$binary->get_uploaded_attribute_value("new_value")){
							} else {
								$this->message.=$binary->get_message();
								$ok=false;
							}
						} else {
							
							$value=trim($_POST['new_value']);
							if(isset($_POST['new_value_prefix']) && trim($_POST['new_value_prefix'])!=''){
								$value=trim($_POST['new_value_prefix']) . ': ' . $value;
							}
							if($newschema->attribute[$ldapname]->validate($value,'user')){
								if($pom=$this->conv_attr_value($ldapname,$value,$newschema->attribute[$ldapname]->type)){
									$attr_array[$dn][$ldapname]=$pom;
								}
							} else {
								$this->message.=$newschema->get_message();
								$ok=false;
							}
						}
					}
					if(is_array($attr_array) && $ok){
						$req=new Ldap_request();
						if($this->debug){
							print "add: ";
							var_dump($attr_array);
							print "\n";
						}
						if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'userAddAttribute',$attr_array,true)){
							$this->message=m(20) . " $ldapname " . m(22);
							$this->message.=$res['result'][$dn]['plugin_message'];
							return true;
						} else {
							$this->result=$req->get_result();
							$this->message=$this->result[$dn]['message'];
							$this->message.=$this->result[$dn]['plugin_message'];
							$this->message.= '<br>' . $req->get_message();
							return false;
						}
					} else {
						return false;
					}
				} else {
					$this->message=m(19);
					return false;
				}
			} else {
				$this->message=m(19);
				return false;
			}
		} else {
			$this->message=m(18);
			return false;
		}
	}
	
	function get_user_data($uid){
		global $soap_params;
		if($this->debug){
			print "<pre>request:\nmethod:userSearch\nfilter:(uid=$uid)\nattributes:all";
			print "</pre>\n";
		}
		$dn="uid=$uid," . BASE_DN;
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall('userSearch', array($_SESSION['uid'],$_SESSION['password'],BASE_DN,"(uid=$uid)",null));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		
		if($this->debug){
			print "<pre>result raw:\n";
			var_dump($result);
			print "\n</pre>\n";
		}	
		
		if($result['code']===0){
			$res=xml_to_array($result['result']);
			if($this->debug){
				print "<pre>result:\n";
				var_dump($res);
				print "\n</pre>\n";
			}
			return $res;
		} else {
			$this->result=xml_to_array($result['result']);
			$this->message=$this->result[$dn]['message'];
			$this->message.=$this->result[$dn]['plugin_message'];
			$this->message.= '<br>' . $result['error'];
			if($this->debug){
				print "<pre>error:\ncode:" . $result['code'] . "\nmessage:" . $result['error'];
				print "\n</pre>\n";
			}
			return false;
		}
	}
	
	
	function chg_pwd(){
		
		$npwd1=$_POST['npassword1'];
		$npwd2=$_POST['npassword2'];
		$oldpwd=base64_encode($_POST['oldpassword']);
		if($oldpwd==''){
			$this->message.=m(6);
			return false;
		} elseif($npwd1=='' || $npwd2==''){
			$this->message.=m(7);
			return false;
		} elseif ($npwd1!=$npwd2) {
			$this->message.=m(8);
			return false;
		} else {
			
			list($ok,$message)=chk_password_strength($npwd1,$_SESSION['uid']);
			//var_dump($ok);
			//var_dump($message);
			if($ok){
				$dn="uid=" . $_SESSION['uid'] . "," . BASE_DN;
				//$newpassword='{SHA}' . base64_encode(pack("H*",sha1($npwd1)));
				$attr_array=array($dn =>array('userPassword'=>$npwd1));
				$req=new Ldap_request();
				if($res=$req->request($_SESSION['uid'],$oldpwd,'userModifyAttribute',$attr_array,true)){
					$this->message.=m(9);
					$this->message.=$res['result'][$dn]['plugin_message'];
					$_SESSION['password']=base64_encode($npwd1);
					unset($_SESSION['must_change']);
					return true;
				} else {
					$this->result=$req->get_result();
					$this->message=$this->result[$dn]['message'];
					$this->message.=$this->result[$dn]['plugin_message'];
					$this->message.= '<br>' . $req->get_message();
					return false;
				}
			} else {
				$this->message.=$message;
				return false;
			}
		}
	}
	
	function chg_user($post_array,$type='all'){
		$uid=$_SESSION['uid'];
		if($uid){
			$dn="uid=$uid," . BASE_DN;
			$newschema=load_schema();
			$oldschema=unserialize($_SESSION['schema']);
			if($oldschema){
				$binary=new Binary();
				// promjena vrijednosti atributa
				$ok=true;				
				foreach ($post_array as $ldapname => $attrvalue) {
					if(isset($newschema->attribute[$ldapname])){
						$attr=$newschema->attribute[$ldapname];
						if(is_array($attrvalue)){
							foreach ($attrvalue as $k => $v){
								if($v==''){
									unset($attrvalue[$k]);
								}
							} 
						}
						if(isset($post_array[$ldapname . '_prefix'])){
							$pref=$post_array[$ldapname . '_prefix'];
							if(is_array($attrvalue)){
								foreach ($attrvalue as $k => $v){
									if($v!=''){
										$attrvalue[$k]=$pref[$k] . ': ' .$attrvalue[$k];
									}
								} 
							} else {
								if($attrvalue!=''){
									$attrvalue=$pref . ': ' .$attrvalue;
								}
							}
						}
						if($oldschema->attribute[$ldapname]->value!=$attrvalue){
							if($this->debug){
								print "<br><br>tip:$type<br>ldapname:$ldapname<br>";
								print "staro:";
								print_r($oldschema->attribute[$ldapname]->value);
								print "<br>novo:";
								print_r($attrvalue);
							}
	
							if(($attr->must=='true' && $type=='must') || $type=='all'){
								if($attr->validate($attrvalue,'user')){
									if (isset($attrvalue)) {
										if(is_array($attrvalue)){
											foreach ($attrvalue as $key=>$val) {
												$pom=$this->conv_attr_value($ldapname,$val,$attr->type);
												if($pom===0 || $pom==='0' || $pom){
													$attr_array[$dn][$ldapname][$key]=$pom;
												}
											}
										} else {
											$pom=$this->conv_attr_value($ldapname,$attrvalue,$attr->type);
											if($pom===0 || $pom==='0' || $pom){
												$attr_array[$dn][$ldapname]=$pom;
											} else {
												$del_attr_array[$dn][$ldapname]='';
											}
										}
									}
								} else {
									$ok=false;
									$this->message.=$attr->get_message();
								}
							}
						}
					}
				}
				if($ok){
					$req=new Ldap_request();
					if(is_array($attr_array)){
						
						if($this->debug){
							print "chg: ";
							var_dump($attr_array);
							print "\n";							
							print "del:";
							var_dump($del_attr_array);
							print "\n";
						}
						if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'userModifyAttribute',$attr_array,true)){
							//$this->message="Podaci o korisniku azurirani.";
							//return true;
							$this->message.=$res['result'][$dn]['plugin_message'];
						} else {
							$this->result=$req->get_result();
							$this->message.=$this->result[$dn]['message'];
							$this->message.=$this->result[$dn]['plugin_message'];
							$this->message.= '<br>' . $req->get_message();
							$ok=false;
						}
					}
					if(is_array($del_attr_array) && $ok){
						if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'userDeleteAttribute',$del_attr_array,true)){
							//$this->message="Podaci o korisniku azurirani.";
							//return true;
							$this->message.=$res['result'][$dn]['plugin_message'];
						} else {
							$this->result=$req->get_result();
							$this->message.=$this->result[$dn]['message'];
							$this->message.=$this->result[$dn]['plugin_message'];
							$this->message.= '<br>' . $req->get_message();
							$ok=false;
						}
					}
					if($ok){
						$this->message.=" " . m(79);
					}
					return $ok;
				} else {
					return false;
				}
			} else {
				$this->message=m(19);
				return false;
			}
		} else {
			$this->message=m(18);
			return false;
		}
	}
	function delete_attribute($ldapname){
		$uid=$_SESSION['uid'];
		$ok=true;
		$ldapname=trim($ldapname);
		$schema=unserialize($_SESSION['schema']);
		$dn="uid=$uid," . BASE_DN;
		if($schema){
			if($schema->attribute[$ldapname]->change[$_SESSION['usertype']]=='false'){
				$this->message.= m(35) . " $ldapname.";
				return false;
			} else {
				if(preg_match('/\[(\d*)\]$/',$ldapname,$matches)){
					if(count($schema->attribute[$ldapname]->value)<2 && $schema->attribute[$ldapname]->must=='true'){
						$this->message.=m(20) . " $ldapname " . m(44);
						$ok=false;
					} else {
						$key=$matches[1];
						$ldapname=substr($ldapname,0,-1*(2+strlen($key)));
						$del_array[$dn]=array($ldapname=>$this->conv_attr_value($ldapname,$schema->attribute[$ldapname]->value[$key],$schema->attribute[$ldapname]->type));
					}
				} else {
					if($schema->attribute[$ldapname]->must=='true'){
						$this->message.=m(20) . " $ldapname " . m(44);
						$ok=false;
					} else {
						$del_array[$dn]=array($ldapname=>'');
					}
				}
				if($del_array && $ok){
					//print_r($del_array);
					$req=new Ldap_request();
					if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'userDeleteAttribute',$del_array,true)){
						$this->message=m(20) . " $ldapname " . m(45);
						$this->message.=$res['result'][$dn]['plugin_message'];
						return true;
					} else {
						$this->result=$req->get_result();
						$this->message=$this->result[$dn]['message'];
						$this->message.=$this->result[$dn]['plugin_message'];
						$this->message.= '<br>' . $req->get_message();
						return false;
					}
				}
			}
		} else {
			$this->message.= m(46) . ": " . m(20) . " $ldapname";
			return false;
		}
		
	}
	function conv_attr_value($ldapname,$attrvalue=false,$type=false){
		if(!$type){
			$type=0;
		}
		if(isset($attrvalue) && trim($attrvalue)!=''){
			/*if($ldapname=='userPassword'){
				$retvalue='{SHA}' . base64_encode(pack("H*",sha1($attrvalue)));			
			} else */
			
			if ($type==='binary'){
				//$retvalue=base64_encode($attrvalue);
				$retvalue=$attrvalue;
			} elseif ($type==='date') {
				$retvalue=conv_date_to_ldap(trim($attrvalue));
			} else {
				$retvalue=trim($attrvalue);	
			}
			return $retvalue;
		} else {
			return false;
		}
	}
	function get_chg_pwd_html($message=false){
		$tpl=new Template(CLASS_INCLUDE_PATH . 'user/tpl','comment');
		$tpl->set_file('psswd', 'chg_pwd.html');
		
		$tpl->set_var('MESSAGE',$message);
		
		$tpl->parse('output', 'psswd');	
		return $tpl->get_var('output');
	}
	
	
	function get_message(){
		return $this->message;
	}
	
}


?>
