<?php	
	
	require_once('/etc/aosi-www/config.php');
	
	//postaviti u path nas path
    set_include_path($our_include_path . PATH_SEPARATOR . get_include_path());
	
    //inkludanje paketa  
	require_once('template.php');

	//inkludanje klasa koje se sigurno koriste
	require_once(CLASS_INCLUDE_PATH . 'make_url/make_url.php');
	require_once(CLASS_INCLUDE_PATH . 'messages/messages.php');
	
	require_once(CLASS_INCLUDE_PATH . 'util/util.php');
	require_once(CLASS_INCLUDE_PATH . 'binary/binary.php');
	require_once(CLASS_INCLUDE_PATH . 'attribute/attribute.php');
	require_once(CLASS_INCLUDE_PATH . 'schema/schema.php');
	require_once(CLASS_INCLUDE_PATH . 'ldap_request/ldap_request.php');
	
	/*********************************************************************/
	// Parse url parameters
    preg_match('~([^?]+)~', $_SERVER['QUERY_STRING'], $regs);
    $CLEAN_QUERY_STRING = $regs[1];
	$CLEAN_QUERY_STRING=urldecode($CLEAN_QUERY_STRING);
 	$tmp_url_array = explode('&', $CLEAN_QUERY_STRING);
 	
	foreach ( $tmp_url_array as $val){
		list($tmp,$tmp1)=explode('=',$val);
		if(isset($tmp1) && isset($tmp) && $tmp1!='' && $tmp!=''){
			$param_array[$tmp]=$tmp1;
		}
	}
	
	$make_url=new Make_url($param_array);
	
	// inicijalizacija session varijabli
	session_start();
	if($param_array['action']=='dologin'){
		require_once(CLASS_INCLUDE_PATH . 'login/login.php');
		$login=new Login();
		if(isset($_POST['uid']) && trim($_POST['uid'])!='' && isset($_POST['password']) && trim($_POST['password'])!=''){
			list($uid,$pom)=explode('@',$_POST['uid'],2);
			$pwd=base64_encode($_POST['password']);
			if($login->autenticate($uid,$pwd,'admin')){
				$_SESSION['uid']=$uid;
				$_SESSION['password']=$pwd;
				$_SESSION['admintype']=$login->get_admintype();
				if($_SESSION['admintype']==3){
					$_SESSION['admin_privileges']=serialize($login->get_admin_privileges($_SESSION['uid'],$_SESSION['password'],$_SESSION['uid']));
				}
				$_SESSION['usertype']='admin';
				$param_array=array(	'show'=>'user_list',
									'noquery'=>'true');
			} else {
				$message=$login->get_message();
			}
		} else {
			$message=m(3);
		}
	}

/*	print "session:";
	print_r($_SESSION);
	print_r($param_array);*/
	
	$title=m(4) . ' ' . REALM . ' - ' . m(49);
	
	if(!(isset($_SESSION['uid'])) || $_SESSION['usertype']!='admin'){
		$param_array['template']='normal';
		$param_array['show']='login_form';
		unset($param_array['action']);
		session_unset();
        session_destroy();
	}

/*	print "session:";
	print_r($_SESSION);
	print_r($param_array);
*/
	// inicijalizacija glavnog template-a
   
    switch ($param_array['template']){
    	case 'new_attribute':
    		$main = new Template(TPL_INCLUDE_PATH, 'keep');
    		$main->set_file('frame', 'add_new.html');
    		break;
    	case 'export':
    		$main = new Template(TPL_INCLUDE_PATH, 'keep');
    		$main->set_file('frame','empty.html');   		
    		break;
    	case 'print_report':
    		$main = new Template(INST_PRINT_REPORT_DIR, 'keep');
    		$main->set_file('frame','print_report.html');
    		break;
    	case 'xml':
    		$main = new Template(TPL_INCLUDE_PATH, 'keep');
    		$main->set_file('frame','blank.html');
    		header ("content-type: text/xml");
    		break;
    	default:
    		$main = new Template(TPL_INCLUDE_PATH, 'keep');
    		$main->set_file('frame', 'normal.html');
    }
    if(isset($param_array['message'])){
    	$message=$param_array['message'];
    }
	
    switch ($param_array['action']){
		case 'logout':
			session_unset();
            session_destroy();
            $param_array['show']='login_form';
            $message=m(5);
			break;
		case 'add_attribute':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			if($admin->add_attribute($param_array)){
				$param_array['show']='opener_close';
				$param_array['opener_url']='index.php?show=edit_user&attributes=' . $param_array['attributes'] . '&uida=' . $param_array['uida'];
				if($message=$admin->get_message()){
					$param_array['opener_url'] .='&message=' . urlencode($message);
				}
			} else {
				$param_array['show']='new_attribute';
				$message=$admin->get_message();
			}
			
			break;
		case 'chg_pwd':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			if($admin->chg_pwd($param_array)){
				$param_array['show']='opener_close';
				$param_array['opener_url']='index.php?show=edit_user&attributes=' . $param_array['attributes'] . '&uida=' . $param_array['uida'];
				if($message=$admin->get_message()){
					$param_array['opener_url'] .='&message=' . urlencode($message);
				}
				$new_password=$admin->get_new_pwd();
				$xor_key=str_pad($_SESSION['uid'], strlen($new_password), $_SESSION['uid'], STR_PAD_LEFT);
				$param_array['opener_url'].='&npwd=' . urlencode(base64_encode($new_password ^ $xor_key));
				$param_array['opener_url'].='&xkl=' . strlen($new_password);
			} else {
				$param_array['show']='chg_pwd_form';
				$message=$admin->get_message();
			}
			
			break;
		case 'revoke_admin_privileges':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->revoke_admin_privileges($param_array['uida']);
			$message=$admin->get_message();
			break;
		case 'add_privilege':
		case 'revoke_privilege':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$op_result=$admin->change_admin_privilege($param_array);
			$message=$admin->get_message();
			if($param_array['action']=='add_privilege'){
				if($op_result){
					$param_array['show']='opener_close';
					$param_array['opener_url']='index.php?show=edit_admin&uida=' . $param_array['uida'];
					if($message && $message!=''){
						$param_array['opener_url'] .='&message=' . urlencode($message);
					}
				} else {
					$param_array['show']='add_privilege_form';
				}
			}
			break;
		case 'delete_user':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->delete_user($param_array['uida']);
			$message=$admin->get_message();
			break;
		case 'delete_users_file':
			$upload_file='true';
		case 'delete_users':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->delete_users($upload_file);
			$message=$admin->get_message();
			$operation_result=$admin->get_result();
			$param_array['show']='delete_result';
			$succ_mess=m(63);
			break;
		case 'extend_users':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->extend_users();
			$message=$admin->get_message();
			$operation_result=$admin->get_result();
			$param_array['show']='extend_result';
			$succ_mess=m(65);
			break;
		case 'add_users':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->upload_users('add_new');
			$param_array['show']='upload_result';
			$message=$admin->get_message();
			$operation_result=$admin->get_result();
			$succ_mess=m(78);
			break;
		case 'change_users':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->upload_users('change');
			$param_array['show']='change_result';
			$message=$admin->get_message();
			$operation_result=$admin->get_result();
			$succ_mess=m(79);
			break;
		case 'upload_schema':
			if(get_new_schema_definition()){
				$message=m(50);
			}
			break;
		case 'upload_logo':
			if(!$org){
				require_once(CLASS_INCLUDE_PATH . 'org/org.php');
				$org=new Org();
			}
			$org->upload_logo();
			$message=$org->get_message();
			break;
		case 'add_new':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			if($new_user_uid=$admin->add_new($_POST,$param_array['attributes'])){
				$param_array['show']='edit_user';
				$param_array['uida']=$new_user_uid;
				$new_password=$admin->get_new_pwd();
			} else {
				$param_array['show']='add_new';
			}
			$message=$admin->get_message();
			break;
		case 'chk_pwd':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->chk_pwd($message);
			$message=$admin->get_message();
			$chk_pwd_image=$admin->get_image();
			break;
		case 'admin_del_attr':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->delete_attribute($param_array['uida'],$param_array['attr_name']);
			$message=$admin->get_message();
			break;
		case 'edit_user':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$admin->chg_user($_POST,$param_array['uida'],$param_array['attributes']);
			$message=$admin->get_message();
			break;	
		case 'edit_org':
			if(!$org){
				require_once(CLASS_INCLUDE_PATH . 'org/org.php');
				$org=new Org();
			}
			$org->edit_org($_POST,'all');
			$message=$org->get_message();
			break;	
		case 'delete_logo':
			if(!$org){
				require_once(CLASS_INCLUDE_PATH . 'org/org.php');
				$org=new Org();
			}
			$org->delete_logo();
			$message=$org->get_message();
			break;	
	}
	
	
	
	if(!$param_array['show']){
		$param_array['show']='user_list';
		$param_array['noquery']='true';
	}
    
	switch ($param_array['show']){
		case 'login_form':
			if(!$login){
				require_once(CLASS_INCLUDE_PATH . 'login/login.php');
				$login=new Login();
			}
			$body=$login->get_login_form_html($message);
			break;
		case 'certify':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_certify_html();
			break;
		case 'select_attributes_for_export':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_select_attributes_html($param_array,$make_url,$message=false);
			break;
		case 'add_privilege_form':
		case 'new_attribute':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_add_attribute_html($param_array,$message);
			break;
		case 'edit_admin':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_edit_admin_html($param_array['uida'],$message);
			break;
		case 'chg_pwd_form':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_chg_pwd_form_html($param_array,$message);
			break;
		case 'user_list':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_user_list_html($param_array,$make_url,$message);
			break;
		case 'admin_list':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_admin_list_html($message);
			break;
		case 'ppolicy_list':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_ppolicy_list_html($message);
			break;
		case 'extend_users_form':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_select_users_form_html('extend',$param_array,$make_url,$message);
			break;
		case 'delete_users_form':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_select_users_form_html('delete',$param_array,$make_url,$message);
			break;
		case 'change_result':
		case 'delete_result':
		case 'extend_result':
		case 'upload_result':		
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_operation_result_html($message,$operation_result,$succ_mess);
			break;
		case 'upload_changes_form':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_upload_ch_form_html($message);
			break;
		case 'upload_delete_form':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_upload_del_form_html($message);
			break;
		case 'upload_form':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_upload_form_html($message);
			break;
		case 'upload_logo_form':
			if(!$org){
				require_once(CLASS_INCLUDE_PATH . 'org/org.php');
				$org=new Org();
			}
			$body=$org->get_upload_logo_form_html($message);
			break;
		case 'chk_pwd_form':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_chk_pwd_html($message,$chk_pwd_image);
			break;
		case 'add_new':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			$body=$admin->get_new_user_html($message,$_POST);
			break;
		case 'edit_user':
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			if(!$new_password){
				if(isset($param_array['npwd']) && isset($param_array['xkl'])){
					$xkl=(int) $param_array['xkl'];
					$xor_key=str_pad($_SESSION['uid'], $xkl, $_SESSION['uid'], STR_PAD_LEFT);
					$new_password=base64_decode($param_array['npwd']) ^ $xor_key;
				}
			}
			$body=$admin->get_edit_user_html($param_array['uida'],$param_array['attributes'] ? $param_array['attributes'] : false,$message,$_POST,$new_password);
			break;
		case 'binarydata':
			if(!$binary){
				$binary=new Binary();
			}
			$binary->get_binary_data($param_array['attr_name'],$param_array['index'],$param_array['uida']);
			break;
		case 'print_report':
			
			break;
		case 'opener_close':
			$opener_close = new Template(TPL_INCLUDE_PATH, 'comment');
    		$opener_close->set_file('opener_close', 'opener_close.html');
    		$opener_close->set_var('OPENER_URL',$param_array['opener_url']);
    		$opener_close->parse('output', 'opener_close');
			$body=$opener_close->get_var('output');
			break;
		case 'export_user_list':
			header ("Cache-Control: cache");
	 		header ("Content-Disposition: attachment; filename=\"export_user_list.csv\"");
			header ("Content-Type: application/octet-stream; name=\"export_user_list.csv\"");
			header ("Pragma: public");
			if(!$admin){
				require_once(CLASS_INCLUDE_PATH . 'admin/admin.php');
				$admin=new Admin();
			}
			print $admin->get_user_list_export($param_array);
			break;
	// org
		case 'edit_org':
			if(!$org){
				require_once(CLASS_INCLUDE_PATH . 'org/org.php');
				$org=new Org();
			}
			$body=$org->get_edit_html('all',$message,$_POST);
			break;
	//action log
		case 'action_log':
			$body=get_action_log();
			break;
		case 'add_users_list_help':
		case 'upload_logo_help':
		case 'delete_users_file_help':
		case 'chg_users_list_help':
		case 'admin_list_help':
		case 'admin_edit_help':
		case 'users_list_help':
		case 'extend_users_help':
		case 'delete_users_help':
			$body=join('',file( TPL_INCLUDE_PATH . $param_array['show'] .'.html'));
			break;
		default:
			$body=join('',file(TPL_INCLUDE_PATH . 'notfound.html'));
			header("HTTP/1.1 404 Not Found");
	}
	switch($param_array['show']){
		case 'binarydata':
		break;
		default:
		$logout_url='index.php?action=logout';
		if(isset($_SESSION['uid'])){
			require_once(CLASS_INCLUDE_PATH . 'menu/menu.php');
			$menu=new Menu();
			$menu_html=$menu->get_html($param_array,'admin');
			$main->set_var('HELP_URL',HELP_URL_ADMIN);
		} else {
			$main->set_var('HELP_URL',HELP_URL);
		}
		
		$main->set_var('MENU',$menu_html);
		$main->set_var('LOGOUT_URL',$logout_url);
		$main->set_var('TITLE',$title);
		$main->set_var('BODY',$body);		
		$main->set_var('REALM',REALM);
		$main->set_var('O',INST_TITLE_PATH ? @file_get_contents(INST_TITLE_PATH) : '');
		$main->parse('output', 'frame');	
		$main->p('output');
	}
?>
