<?PHP

class Login{
	
	var $message;
	var $debug=false;
	var $admintype;
	var $must_change_pwd=false;
	
	function get_login_form_html($message=false){
		$login_tpl = new Template(CLASS_INCLUDE_PATH ."login/tpl/", 'comment');
   	 	$login_tpl->set_file('login_form', 'login_form.html');
   	 	$login_tpl->set_var('MESSAGE',$message);
   	 	$login_tpl->set_var('REALM',REALM);
   	 	$login_tpl->parse('output', 'login_form');	
		return $login_tpl->get_var('output');
	}
	
	function autenticate_user($uid,$password){
		global $soap_params;
		if($this->debug){
			print "<pre>request:\nmethod:ldapBind:\nuid:$uid\nusertype:$usertype\n";
			print "</pre>\n";
		}
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			//$result = $client->__soapCall('ldapBind', array($uid,$password,BASE_DN));	
			$result = $client->__soapCall('userSearch', array($uid,$password,BASE_DN,"(uid=$uid)",'uid'));
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if(!$this->message){
            	$this->message=m(0);
			}
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($this->debug){
			print "<pre>result raw:\n";
			var_dump($result);
			print_r($client);
			print '$result[\'result\']' . $result['result'] . "|";
			print "\n</pre>\n";
		}
		if($result['code']===0){
			$arr=xml_to_array($result['result']);
			if($this->debug){
				print_r($arr);
			}
			if($arr["uid=$uid," . BASE_DN]['pwdPolicySubEntry']){
				$this->must_change_pwd=true;
				switch(substr($arr["uid=$uid," . BASE_DN]['pwdPolicySubEntry'],0,18)){
					case 'Lozinka istjece za':
						$this->message=m(105) . ' ' . substr($arr["uid=$uid," . BASE_DN]['pwdPolicySubEntry'],18) . ' ' . m(102);
					break;
					case 'Broj autentikacija':
						$this->message=m(103). ' ' . substr($arr["uid=$uid," . BASE_DN]['pwdPolicySubEntry'],55,-1) . ' '. m(104) . ' ' . m(102);
					break;
					default:
						$this->message=m(101);
					break;
				}
			}
			return true;
		} elseif($result['code']==49){
			if(strpos($result['result'],'Loznika je istekla')!==false){
				$this->message=m(100);
			}
		}
		$this->message.=" " . m(1);
		return false;
	}
	
	function autenticate($uid,$password,$usertype){
		global $soap_params;
		if($this->debug){
			print "<pre>request:\nmethod:ldapBind:\nuid:$uid\nusertype:$usertype\n";
			print "</pre>\n";
		}
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall('ldapBind', array($uid,$password,BASE_DN));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if(!$this->message){
      	$this->message=m(0);
			}
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($this->debug){
			print "<pre>result raw:\n";
			var_dump($result);
			print_r($client);
			print "\n</pre>\n";
		}
		if($result['code']===0){
			if($usertype=='admin'){
				switch ($result['result']){
					case 1 :
					case 2 :
					case 3 :
						$this->admintype=$result['result'];
						return true;
						break;
					default:
						$this->message=m(2);
						return false;
				}
			} else {
				return true;
			}
		} else {
			$this->message=m(1);
			return false;
		}
	}
	
	function get_message(){
		return $this->message;
	}
	function get_admintype(){
		return $this->admintype;
	}
	function get_admin_privileges($bind_uid,$bind_pwd,$uid=null){
		global $soap_params;
		
		if($this->debug){
			print "<pre>request:\nmethod:ldapAdminInfo\nbind_uid:$bind_uid\nbind_pwd:$bind_pwd\nuid:$uid\n";
			print "</pre>\n";
		}
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall('ldapAdminInfo', array($bind_uid,$bind_pwd,BASE_DN,$uid));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if(!$this->message){
            	$this->message=m(0);
            }
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($this->debug){
			print "<pre>result raw:\n";
			var_dump($result);
			print "\n</pre>\n";
		}
	
		if($result['code']===0){
			$arr=xml_to_array($result['result']);
			if($uid){
				return $arr["uid=$uid," . BASE_DN];
			} else {
				return $arr;
			}
		} else {
			$this->message=$result['error'];
			return false;
		}
	}
}


?>
