<?php
	require_once('/etc/aosi-www/config.php');
	
	//postaviti u path nas path
    set_include_path($our_include_path . PATH_SEPARATOR . get_include_path());
	
    //inkludanje paketa  
	require_once('template.php');
	
	//inkludanje klasa koje se sigurno koriste
	require_once(CLASS_INCLUDE_PATH . 'make_url/make_url.php');
	require_once(CLASS_INCLUDE_PATH . 'messages/messages.php');
	
	require_once(CLASS_INCLUDE_PATH . 'util/util.php');
	require_once(CLASS_INCLUDE_PATH . 'binary/binary.php');
	require_once(CLASS_INCLUDE_PATH . 'attribute/attribute.php');
	require_once(CLASS_INCLUDE_PATH . 'schema/schema.php');
	require_once(CLASS_INCLUDE_PATH . 'ldap_request/ldap_request.php');
	
	/*********************************************************************/
	// Parse url parameters
    preg_match('~([^?]+)~', $_SERVER['QUERY_STRING'], $regs);
    $CLEAN_QUERY_STRING = $regs[1];
	$CLEAN_QUERY_STRING=urldecode($CLEAN_QUERY_STRING);
 	$tmp_url_array = explode('&', $CLEAN_QUERY_STRING);
 	
	foreach ( $tmp_url_array as $val){
		list($tmp,$tmp1)=explode('=',$val);
		if(isset($tmp1) && isset($tmp) && $tmp1!='' && $tmp!=''){
			$param_array[$tmp]=$tmp1;
		}
	}
	
	$make_url=new Make_url($param_array);
	
	// inicijalizacija session varijabli
	session_start();
	if($param_array['action']=='dologin'){
		require_once(CLASS_INCLUDE_PATH . 'login/login.php');
		$login=new Login();
		if(isset($_POST['uid']) && trim($_POST['uid'])!='' && isset($_POST['password']) && trim($_POST['password'])!=''){
			list($uid,$pom)=explode('@',$_POST['uid'],2);
			$pwd=base64_encode($_POST['password']);
			//if($login->autenticate($uid,$pwd,'user')){
			if($login->autenticate_user($uid,$pwd)){
				$_SESSION['uid']=$uid;
				$_SESSION['password']=$pwd;
				$_SESSION['usertype']='user';
				if($login->must_change_pwd===true){
					$_SESSION['must_change']=true;
					$message=$login->get_message();
				} else {
					$param_array=array('show'=>'user_data');
				}
				unset($_SESSION['admintype']);
			} else {
				$message=$login->get_message();
			}
		} else {
			$message=m(3);
		}
	}

	/*print "session:";
	print_r($_SESSION);
	print_r($param_array);*/
	
	$title=m(4) . ' ' . REALM;
	
	if(!(isset($_SESSION['uid'])) || $_SESSION['usertype']!='user'){
		$param_array['show']='login_form';
		unset($param_array['action']);
		session_unset();
    session_destroy();
	} elseif($_SESSION['must_change']==true && $param_array['action']!='chg_pwd' && $param_array['action']!='logout'){
		$param_array=array('show'=>'chg_pwd');
		if(!$message){
			$message=m(101);
		}
	}
	
	// inicijalizacija glavnog template-a
    $main = new Template(TPL_INCLUDE_PATH, 'comment');
    switch ($param_array['template']){
    	case 'new_attribute':
    		$main->set_file('frame', 'add_new.html');
    		break;
    	default:
    		$main->set_file('frame', 'normal.html');
    }
    if(isset($param_array['message'])){
    	$message=$param_array['message'];
    }
	
    switch ($param_array['action']){
		case 'logout':
				session_unset();
        session_destroy();
        $param_array['show']='login_form';
        $message=m(5);
			break;
		case 'add_attribute':
			if(!$user){
				require_once(CLASS_INCLUDE_PATH . 'user/user.php');
				$user=new User();
			}
			if($user->add_attribute($param_array)){
				$param_array['show']='opener_close';
				$param_array['opener_url']='index.php?show=user_data&attributes=' . $param_array['attributes'] . '&uida=' . $_SESSION['uid'];
				if($message=$user->get_message()){
					$param_array['opener_url'] .='&message=' . urlencode($message);
				}
			} else {
				$param_array['show']='new_attribute';
				$message=$user->get_message();
			}
			break;
		case 'chg_user_data':
			if(!$user){
				require_once(CLASS_INCLUDE_PATH . 'user/user.php');
				$user=new User();
			}
			$user->chg_user($_POST,$param_array['attributes'] ? $param_array['attributes'] : 'all');
			$message=$user->get_message();
			break;
		case 'chg_pwd':
			if(!$user){
				require_once(CLASS_INCLUDE_PATH . 'user/user.php');
				$user=new User();
			}
			if($user->chg_pwd()){
				$param_array['show']='user_data';
			} else {
				$param_array['show']='chg_pwd';
			}
			$message=$user->get_message();
			break;
		case 'user_del_attr':
			if(!$user){
				require_once(CLASS_INCLUDE_PATH . 'user/user.php');
				$user=new User();
			}
			$user->delete_attribute($param_array['attr_name']);
			$message=$user->get_message();
			break;
	
	}
	
	
	
	if(!$param_array['show']){
		$param_array['show']='user_data';
	}
    
	switch ($param_array['show']){
		case 'login_form':
			if(!$login){
				require_once(CLASS_INCLUDE_PATH . 'login/login.php');
				$login=new Login();
			}
			$body=$login->get_login_form_html($message);
			break;
		case 'opener_close':
			$opener_close = new Template(TPL_INCLUDE_PATH, 'comment');
    		$opener_close->set_file('opener_close', 'opener_close.html');
    		$opener_close->set_var('OPENER_URL',$param_array['opener_url']);
    		$opener_close->parse('output', 'opener_close');
			$body=$opener_close->get_var('output');
			break;
		case 'new_attribute':
			if(!$user){
				require_once(CLASS_INCLUDE_PATH . 'user/user.php');
				$user=new User();
			}
			$body=$user->get_add_attribute_html($param_array,$message);
			break;
		case 'user_data':
			if(!$user){
				require_once(CLASS_INCLUDE_PATH . 'user/user.php');
				$user=new User();
			}
			$body=$user->get_edit_user_html($param_array['attributes'],$message,$_POST);
			break;
		case 'chg_pwd':
			if(!$user){
				require_once(CLASS_INCLUDE_PATH . 'user/user.php');
				$user=new User();
			}
			$body=$user->get_chg_pwd_html($message);
			break;
		case 'binarydata':
			if(!$binary){
				$binary=new Binary();
			}
			$binary->get_binary_data($param_array['attr_name'],$param_array['index'],$param_array['uida']);
			break;
		case 'forbidden':
			$body=join('',file(TPL_INCLUDE_PATH . 'forbidden.html'));
			header("HTTP/1.1 403 Forbidden");
			break;
		default:
			$body=join('',file(TPL_INCLUDE_PATH . 'notfound.html'));
			header("HTTP/1.1 404 Not Found");
	}
	if($param_array['show']!='binarydata'){
		$logout_url='index.php?action=logout';
		if(isset($_SESSION['uid'])){
			require_once(CLASS_INCLUDE_PATH . 'menu/menu.php');
			$menu=new Menu();
			$menu_html=$menu->get_html($param_array,'user');
			$main->set_var('HELP_URL',HELP_URL_USER);
		} else {
			$main->set_var('HELP_URL',HELP_URL);
		}
		
		$main->set_var('MENU',$menu_html);
		$main->set_var('LOGOUT_URL',$logout_url);
		$main->set_var('TITLE',$title);
		$main->set_var('BODY',$body);		
		$main->set_var('REALM',REALM);
		$main->set_var('O',INST_TITLE_PATH ? @file_get_contents(INST_TITLE_PATH) : '');
		$main->parse('output', 'frame');	
		$main->p('output');
	}
?>
