#!/usr/bin/perl
BEGIN {
	unshift(@INC,'/etc/aosi');
}
use config;
use warnings;
use utf8;
use Net::LDAP;
use Net::LDAP::LDIF;
use Data::Dumper;
use Config::General;
BEGIN {
	unshift(@INC,$config::lib_dir);
}
use Plugins::o365connectAttributes;


my $VERSION  = 1.0;
my $plugin_name = 'o365connect';

my $conf = new Config::General(
    -ConfigFile      => $config::plugins_dir . '/'.$plugin_name.'.conf',
    -InterPolateVars => TRUE,
    -AutoLaunder     => TRUE
);
my %cfg = $conf->getall;

my $base_dn=$config::base_dn;
my $realm = base2realm($base_dn);
my $ldif_file=$config::log_dir . '/' . $cfg{'ofc_file_prefix'} ."_". $realm . $cfg{'ofc_file_ext'};

my @atts=[keys %{$Plugins::o365connectAttributes::attr_map}];

my $ldap_user=$config::ldap_user;
my ($ldap_ip,$ldap_port)=split(/:/,$config::ldap_server);

#procitati ldap administracijski password
my $pwd=_get_pwd($config::ldap_pwd_file);
my $ldap;
my $mesg;

unless ($ldap = Net::LDAP->new($ldap_ip, port => $ldap_port, version => 'LDAPv3')){
	die("Greska! Ne mogu kontaktirati LDAP posluzitelj.\n");
}
unless ($mesg = $ldap->bind($ldap_user, version=>3, password => $pwd)){  
	die("Greska! Neispravna zaporka. Ne mogu se spojiti na LDAP posluzitelj.\n");
}
$mesg->code && die die("Greska 1:" . $mesg->error."\n");

my $ldap_filter='(uid=*)';
unless($mesg = $ldap->search (base => $base_dn, sizelimit => 0, scope  =>'sub', attrs => @atts, filter => $ldap_filter, timelimit => 360)){
	die("Greska 2:" . $mesg->error."\n");
}
$mesg->code && die die("Greska 3:" . $mesg->error."\n");

my $ldif = Net::LDAP::LDIF->new( "$ldif_file", "w", onerror => 'die',encode => 'base64',change => '1');

while (my $ent = $mesg->shift_entry) {
	$ent->changetype('add');
	$ldif->write_entry($ent);
}
$ldif->done();

sub _get_pwd {
    my ($file) = @_;
    my ($real);

    open(FILE, "$file") or die "$0: can not open file $file for reading ($!)\n";
    $real = <FILE>;
    close(FILE);
    chomp($real);
    return $real;
}
sub base2realm {
    my ($base) = @_;
    my ($temp, $realm);

    ($realm) = split(/,/, $base);
    ($temp, $realm) = split(/=/, $realm);

    return $realm;
}
