<?PHP

class Binary{

	var $message;
	
	function get_binary_data($ldapname=false,$index=false,$uid=false){
		if($ldapname && $ldapname!=''){
			if($_SESSION['usertype']=='user'){
            	$uid=$_SESSION['uid'];
				$function_name='userBinSearch';
            } else {
				if(!$uid || $uid==''){
					$uid=$_SESSION['uid'];
				}
				$function_name='ldapBinSearch';
            }
			$dn="uid=$uid," . BASE_DN;
			$filter="(uid=$uid)";
			$schema=load_schema();
			$content_type=$schema->attribute[$ldapname]->attrtype['content_type'];
			if(!$content_type || $content_type==''){
				$content_type='Application/Octet-Stream';
			}
			$req=new Ldap_request();
			if($res=$req->binary_search_request($_SESSION['uid'],$_SESSION['password'],$function_name,$filter,$ldapname,$index)){
				header("Content-type: $content_type");
				print base64_decode($res[$dn][$ldapname]);
				return true;
			} else {
				print $req->get_message();
				return false;
			}
		} else {
			return false;
		}
	}
	
	function get_message(){
		return $this->message;
	}
	
	function get_uploaded_attribute_value($inputname){

		$remoteFile = $_FILES[$inputname]['name'];
		$fileType = $_FILES[$inputname]['type'];
		$fileSize = $_FILES[$inputname]['size'];
	
		$errMessages = array (
				m(37),
				m(38) . ": " . m(39),
				m(38) . ": " . m(39),
				m(38) . ": " . m(40),
				m(38) . ": " . m(41),
				m(38) . ": " . m(42),
				m(38) . ": " . m(43)
		);
	
		if (strlen($remoteFile) == 0) {
			$error = 5;	
		} elseif ($fileSize < 1) {
			$error = 6;
		} else $error = $_FILES[$inputname]['error'];
		
		if($error==0){
			return base64_encode(join(file($_FILES[$inputname]['tmp_name']),''));
		} else {
			$this->message=$errMessages[$error];
			return false;
		}
		
	}
	
}


?>