<?php

class AAIAttribute{
	
	var $ldapname;
	var $name;
	var $type;
	var $attrtype; //atributi tipa (duljina, naziv sifrarnika ...)
	var $desc;
	var $regex;
	var $must;
	var $multiple;
	var $view;
	var $change;
	var $vocabulary;
	var $value;
	var $message;
	var $html;
	var $schematype;
	var $spec_attr=array('hrEduPersonUniqueNumber','hrEduOrgUniqueNumber');
	var $hrEduPersonUniqueNumber_prefix=array('JMBG','JMBAG','LOCAL_NO','MBZ','OIB','PASSPORT_NO');
	var $hrEduOrgUniqueNumber_prefix=array('MBUST','RKDP','MZOS_SIFRA','OIB');

	function __construct ($attr_def_array,$get_new_vocabulary=false){
		
		$i=0;
		$ok=true;
		//print_r($attr_def_array);
		while($i<count($attr_def_array) && $ok){
			$attr=$attr_def_array[$i];
			switch($attr['tag']){
					case 'attribute':{
						$this->ldapname=trim($attr['attributes']['ldapname']);
						break;
					}
					case 'regex':{
						if (! (trim($attr['value']) == "") ){
							$this->regex='/' . trim($attr['value']) . '/';
						}
						break;
					}
					case 'name':
					case 'desc':{
						if (! (trim($attr['value']) == '') ){
							$this->{$attr['tag']}=trim($attr['value']);
						}
						
						break;
					}
					case 'type':{
						if($attr['type']=='open'){
							$level=$attr['level'];
							$i++;
							if($attr_def_array[$i]['level']<=$level){
								$this->message.=m(11) . "4";
								$ok=false;
							} else {
								while($attr_def_array[$i]['level']>$level){ 
									$this->type=$attr_def_array[$i]['tag'];
									if (is_array($attr_def_array[$i]['attributes'])) {
								    	foreach ($attr_def_array[$i]['attributes'] as $key => $val) {
								    		$this->attrtype[$key] = $val;
										}
									}
									$i++;
								}
								if($attr_def_array[$i]['tag']=='type' && $attr_def_array[$i]['type']=='close'){
									//$i++;
								} else {
									$this->message.=m(11) . "5!";
									$ok=false;									
								}
							}
							
						} else {
							$this->message.=m(11) . "3!";
							$ok=false;
						}
						break;
					}
					case 'status':{
						$this->must=trim($attr['attributes']['must']);
						break;
					}
					case 'frequency':{
						$this->multiple=trim($attr['attributes']['multiple']);
						if($this->multiple=='true'){
							$this->value=array();
						}
						break;
					}
					case 'view':
					case 'change':{
						if (is_array($attr['attributes'])) {
				    	foreach ($attr['attributes'] as $key => $val) {
				    		$this->{$attr['tag']}[$key] = $val;
						}
					}
					break;
					}
			}	
			$i++;
		}	
		if($this->type=='vocabulary'){
			if(isset($this->attrtype['name']) && isset($this->attrtype['uri'])){
				if($get_vocabulary){
					get_vocabulary($this->attrtype['name'],$this->attrtype['uri']);
				}
				$this->vocabulary=load_vocabulary($this->attrtype['name'],$this->attrtype['uri']);
			}
		}
	}
	
	function get_html(){
		return $this->html;
	}
	
	function unset_html(){
		unset($this->html);	
	}
	
	function set_value($value){
		if($this->type=='date'){
			$value=conv_date_from_ldap($value);				
		}
		if($this->multiple=='true' && !is_array($value)){
			$this->value=array($value);
		} else {
			$this->value=$value;
		}
	//	$this->make_html();	
	}
	
	function check_value($val){
//		print "vrijednost:$val\n";
		
		$ok=true;
		if($this->regex){
			if(!preg_match($this->regex,$val)){
				$ok=false;
				$this->message.=" " . m(20) . " " . $this->ldapname . " " . m(29);
			}
		}
		switch ($this->type){
			case 'string':{
				if(!$this->attrtype['length']){
					$this->attrtype['length']=255;
				}
				if(strlen($val)>$this->attrtype['length']){
					$ok=false;
					$this->message.=" " . m(20) . " " . $this->ldapname ." " . m(30) ." ". $this->attrtype['length'] . " "  . m(31);
				}
				break;
			}
			case 'number':{
				$pomint=(int) $val;
				if($pomint!=$val){
					$ok=false;
					$this->message.=" " . m(20) . " " . $this->ldapname ." " . m(32);
				}
				break;
			}
			case 'date':{
				if($val!='NONE'){
					list($pomd,$pomm,$pomg)=explode('.',$val,3);
					
					$pomg=(int) $pomg;
					$pomm=(int) $pomm;
					$pomd=(int) $pomd;
					if(!@checkdate($pomm,$pomd,$pomg)){
						$ok=false;
						$this->message.=" " . m(20) . " " . $this->ldapname ." " . m(33);
					}
				}
				break;
			}
			case 'vocabulary':{
				if(substr($val,0,4)!='urn:'){
					if(!isset($this->vocabulary[$val])){
						$ok=false;
						$this->message.=" " . m(20) . " " . $this->ldapname ." " . m(34) . " " . $this->attrtype['name'] .".";
					}
				}
				break;
			}
		}
		/*print $ok ? "u redu" : "nije";
		print "\n";*/
		return $ok;
	}
	
	function validate($value=NULL,$usertype,$new=false){
		if($this->change[$usertype]!='true' && !$new){
			$this->message.=" " . m(35) . " " . $this->ldapname .".";
			$ok=false;
		} else {
			$ok=true;
			if(is_array($value)){
				if($this->multiple=='false'){
					$ok=false;
					$this->message.=" " . m(20) . " " . $this->ldapname . " " . m(27);
				} else {
					$tmpval=$value;
					foreach ($tmpval as $k=> $v) {
						if($v==''){
							unset($tmpval[$k]);
						}
					}
					if(count($tmpval)<1){
						if($this->must=='true'){
							$ok=false;
							$this->message.=" " . m(20) . " " . $this->ldapname ." " .m(28);
						}
					} else {
						foreach ($value as $key=>$val){
							if(!$this->check_value($val)){
								$ok=false;
							}
						}
					}
	
				}
			} else {
				if(is_null($value) || $value==''){
					if($this->must!='false'){
						$this->message.=" " . m(20) . " " . $this->ldapname ." " . m(36);
						$ok=false;
					}
				} else {
					if(!$this->check_value($value)){
						$ok=false;
					}
				}
			}
		}

/*print "<br>validacija-------------------<br>";
print "ldapname:" . $this->ldapname . "<br>";
		print "vrijednost:";
		print_r($value);
		print "<br>";
		print "validacija:";
		print $ok ? 'ok' : 'no';
		print "<br>message:" . $this->message;
print "<br>endvalidacija-------------------<br>";*/
		return $ok;
	}
	
	function get_add_new_html($uid,$attribute,$attributes='must',$usertype='user',$message=false,$privilege=false,$urn_value=false){
		$tpl=new Template(CLASS_INCLUDE_PATH . 'attribute/tpl','comment');
		if(in_array($this->ldapname,$this->spec_attr)){
			$spec='_spec';
		}
		$tpl->set_file('atr', 'add_' . $this->type . $spec .'.html');
		$tpl->set_var('MESSAGE',$message);
		$tpl->set_var('NAZIV',$this->name);
		$tpl->set_var('LDAPNAZIV',$this->ldapname);
		$tpl->set_var('OPIS',$this->desc);
		if($privilege){
			$form_action='index.php?template=new_attribute&action=add_privilege&ldapname=' . $attribute . '&uida=' . $uid . '&old_urn_value=' . urlencode($urn_value);
		} else {
			$form_action='index.php?template=new_attribute&action=add_attribute&attributes=' . $attributes . '&attribute=' . $attribute . '&uida=' . $uid;
		}
		$tpl->set_var('FORM_ACTION',$form_action);
		switch ($this->type){
			case 'binary':
			break;
			case 'vocabulary':
				$tpl->set_block('atr','option_tpl','option');
				$vrijednost=trim($_POST['new_value']);
				foreach ($this->vocabulary as $key=>$val){
					$tpl->set_var('VRIJEDNOST',$key);
					$tpl->set_var('VRIJEDNOST_OPIS',$val);
					if($key==$vrijednost){
						$tpl->set_var('SELECTED','SELECTED');
					} else {
						$tpl->set_var('SELECTED','');
					}
					$tpl->parse('option','option_tpl',true);
				}
			break;
			default:
				if(in_array($this->ldapname,$this->spec_attr)){
					$tpl->set_block('atr','option_tpl','option');
					$vrijednost=trim($_POST['new_value_prefix']);
					foreach ($this->{$this->ldapname . '_prefix'} as $val){
						if($val!='OIB'){
							$tpl->set_var('VRIJEDNOST_PREFIX',$val);
							if($val==$vrijednost){
								$tpl->set_var('SELECTED','SELECTED');
							} else {
								$tpl->set_var('SELECTED','');
							}
							$tpl->parse('option','option_tpl',true);
						}
					}
				}
				$tpl->set_var('VRIJEDNOST',$_POST['new_value']);
				$tpl->set_var('DULJINA',$this->attrtype['length'] ? $this->attrtype['length'] : '255');
		}
		$tpl->parse('output','atr');
		return $tpl->get_var('output');
	}
	
	function make_html($uid,$type,$usertype,$new=false){
		if($usertype=='admin'){
			$show='show=edit_user';
			$action='action=admin_del_attr';
		} else {
			$show='show=user_data';
			$action='action=user_del_attr';
		}
		if($type=='all'){
			$attrs='attributes=all';
		} else {
			$attrs='attributes=must';
		}
		if($this->view[$usertype]=='true'){
			$tpl=new Template(CLASS_INCLUDE_PATH . 'attribute/tpl','comment');
			switch ($this->type){
				case 'binary':
					$tplfile="binary.html";
					$tpl->set_file('atr', $tplfile);
					$tpl->set_block('atr','atr_blok_tpl','atr_blok');
					$tpl->set_block('atr_blok_tpl','visestr_blok_tpl','visestr_blok');
					$tpl->set_block('visestr_blok_tpl','visestr_input_tpl','visestr_input');
					$tpl->set_block('visestr_blok_tpl','visestr_brisi_tpl','visestr_brisi');
					$tpl->set_block('atr_blok_tpl','visestr_zadnji_submit_tpl','visestr_zadnji_submit');
					break;
				case 'vocabulary':{
					if($this->change[$usertype]=='true' || ($usertype=='admin' && $new)){
						$tplfile=$this->type . ".html";
						$tpl->set_file('atr', $tplfile);
						$tpl->set_block('atr','atr_blok_tpl','atr_blok');
						$tpl->set_block('atr_blok_tpl','visestr_blok_tpl','visestr_blok');
						$tpl->set_block('visestr_blok_tpl','visestr_input_tpl','visestr_input');
						$tpl->set_block('visestr_blok_tpl','visestr_input_hidden_tpl','visestr_input_hidden');
						$tpl->set_block('visestr_blok_tpl','visestr_brisi_tpl','visestr_brisi');
						$tpl->set_block('atr_blok_tpl','visestr_zadnji_blok_tpl','visestr_zadnji_blok');
					} else {
						$tplfile="non_editable.html";
						$tpl->set_file('atr', $tplfile);
					}
					break;
				}
				default:{
					if($this->change[$usertype]=='true' || ($usertype=='admin' && $new)){
						if($this->type=='date'){
							$tplfile="date";
						} else {
							$tplfile="string";
						}
						if(in_array($this->ldapname,$this->spec_attr)){
							$tplfile.='_spec';
						}
						$tplfile.='.html';
						$tpl->set_file('atr', $tplfile);
						$tpl->set_block('atr','atr_blok_tpl','atr_blok');
						$tpl->set_block('atr_blok_tpl','visestr_blok_tpl','visestr_blok');
						$tpl->set_block('visestr_blok_tpl','visestr_input_tpl','visestr_input');
						$tpl->set_block('visestr_blok_tpl','visestr_brisi_tpl','visestr_brisi');
						$tpl->set_block('atr_blok_tpl','visestr_zadnji_blok_tpl','visestr_zadnji_blok');
						if(in_array($this->ldapname,$this->spec_attr)){
							//$tpl->set_block('visestr_input_tpl','option_tpl','option');
							$prefix=true;
						}
					} else {
						$tplfile="non_editable.html";
						$tpl->set_file('atr', $tplfile);
					}
					break;
				}
				
			}
			
			$tpl->set_var('NAZIV',$this->name);
			$tpl->set_var('LDAPNAZIV',$this->ldapname);
			$tpl->set_var('OPIS',$this->desc);	
			$tpl->set_var('MUST',$this->must=='true' ? '*' : '&nbsp;');	
			switch ($this->type){
				case 'binary':

					if(!is_array($this->value)){
						$value=array($this->value);
					} else {
						$value=$this->value;
					}
					if(count($value)>=1){
						foreach ($value as $key=>$val){
							if(isset($val) && $val!=''){
								$tpl->set_var('visestr_zadnji_blok','');
								$show_url='index.php?show=binarydata&attr_name='. $this->ldapname . '&index='. urlencode($val) . '&uida=' .$uid;
								$tpl->set_var('SHOW_URL',$show_url);
								if($this->schematype!='person'){
									$tpl->set_var('visestr_brisi','<br>');
								} else {
									if($this->change[$usertype]=='true' && !($this->must=='true' && count($value)<2) && !$new){
										$tpl->set_var('OBRISI_URL','index.php?' . $action .'&' . $show . '&uida=' .$uid .'&attr_name=' . $this->ldapname . '[' . $key .']&' .$attrs);
										$tpl->parse('visestr_brisi','visestr_brisi_tpl');
									} else {
										$tpl->set_var('visestr_brisi','<br>');
									}
								}
								$tpl->parse('visestr_input','visestr_input_tpl');
								$tpl->parse('visestr_blok','visestr_blok_tpl',true);
							} else {
								$tpl->set_var('visestr_blok','');
							}
						}
					} else {
						$tpl->set_var('visestr_blok','');
					}
					if($this->change[$usertype]=='true' || ($usertype=='admin' && $new)){
						$tpl->parse('visestr_zadnji_submit','visestr_zadnji_submit_tpl');
					} else {
						$tpl->set_var('visestr_zadnji_submit','');
					}
					$tpl->parse('atr_blok','atr_blok_tpl',true);
					break;
				case 'vocabulary':{
					if($this->change[$usertype]=='true' || ($usertype=='admin' && $new)){
						$tpl->set_block('visestr_input_tpl','visestr_option_tpl','visestr_option');
						if($this->multiple=='false' || !isset($this->value) || (is_array($this->value) && count($this->value)<1)){
							$tpl->set_var('visestr_brisi','');
							if($this->multiple=='true'){						
								$tpl->set_var('NAZIV_INPUT',$this->ldapname . '[0]');
							} else {
								$tpl->set_var('NAZIV_INPUT',$this->ldapname);
							}
							//&& $this->ldapname != 'schacHomeOrganizationType' krpam 
							if(is_array($this->value)){
								$val=$this->value[0];
                            } else {
								$val=$this->value;
                            }

							if(substr($val,0,4)=='urn:' && $this->ldapname != 'schacHomeOrganizationType'){
								$tpl->set_var('VRIJEDNOST',$this->value);
								$tpl->set_var('visestr_input','');
								$tpl->parse('visestr_input_hidden','visestr_input_hidden_tpl');
							} else {
								$tpl->set_var('VRIJEDNOST','');
								$tpl->set_var('VRIJEDNOST_OPIS',m(90));
							
								if(!isset($this->value) || (is_array($this->value) && count($this->value)<1)){
									$tpl->set_var('SELECTED','SELECTED');
								}
								//ako je atribut obavezan ne prikazuj opciju nije postavljeno
								//if($this->must=='true' && count($value)<2){
								if($this->must=='true'){
									$tpl->set_var('visestr_option','');
								} else {
									$tpl->parse('visestr_option','visestr_option_tpl',true);
								}
								foreach ($this->vocabulary as $key=>$val){
									$tpl->set_var('VRIJEDNOST',$key);
									$tpl->set_var('VRIJEDNOST_OPIS',$val);
									if($key===0 || $key==='0' ){
										if($this->value===0 || $this->value==='0'){
											$tpl->set_var('SELECTED','SELECTED');
										} else {
											$tpl->set_var('SELECTED','');
										}
									} else {
										if($key==$this->value){
											$tpl->set_var('SELECTED','SELECTED');
										} else {
											$tpl->set_var('SELECTED','');
										}
									}
									$tpl->parse('visestr_option','visestr_option_tpl',true);
								}
								$tpl->set_var('visestr_input_hidden','');
								$tpl->parse('visestr_input','visestr_input_tpl');
							}
							
							$tpl->parse('visestr_blok','visestr_blok_tpl');	
							$tpl->parse('atr_blok','atr_blok_tpl');
							$tpl->set_var('visestr_zadnji_blok','');
						} else {
							foreach ($this->value as $key=>$val){
								$tpl->set_var('visestr_option','');
								$tpl->set_var('NAZIV_INPUT',$this->ldapname . '[' . $key .']');
								if(substr($val,0,4)=='urn:' && $this->ldapname != 'schacHomeOrganizationType'){
									$tpl->set_var('VRIJEDNOST',$val);
									$tpl->parse('visestr_input_hidden','visestr_input_hidden_tpl');
									$tpl->set_var('visestr_input','');
								} else {
									$tpl->set_var('visestr_input_hidden','');
									foreach ($this->vocabulary as $kkey=>$vval){
										$tpl->set_var('VRIJEDNOST',$kkey);
										$tpl->set_var('VRIJEDNOST_OPIS',$vval);
										if($kkey===0 || $kkey==='0'){
											if($val===0 || $val==='0'){
												$tpl->set_var('SELECTED','SELECTED');
											} else {
												$tpl->set_var('SELECTED','');
											}
										} else {
											if($kkey==$val){
												$tpl->set_var('SELECTED','SELECTED');
											} else {
												$tpl->set_var('SELECTED','');
											}
										}
										$tpl->parse('visestr_option','visestr_option_tpl',true);
									}
									$tpl->parse('visestr_input','visestr_input_tpl');
								}
								if($this->schematype!='person'){
									$tpl->set_var('visestr_brisi','<br>');
								} else {
									$tpl->set_var('OBRISI_URL','index.php?' . $action .'&' . $show . '&uida=' .$uid .'&attr_name=' . $this->ldapname . '[' . $key .']&' .$attrs );
									if(($this->must=='true' && count($this->value)<2) || $new){
										$tpl->set_var('visestr_brisi','<br>');
									} else {
										$tpl->parse('visestr_brisi','visestr_brisi_tpl');
									}
								}
								$tpl->parse('visestr_blok','visestr_blok_tpl',true);
							}
							if(!$new && $this->schematype=='person'){
								$tpl->parse('visestr_zadnji_blok','visestr_zadnji_blok_tpl');
							} else {
								$tpl->set_var('visestr_zadnji_blok','');
							}
							$tpl->parse('atr_blok','atr_blok_tpl',true);
						}
					} else {
						if($this->multiple=='false' || !isset($this->value) || (is_array($this->value) && count($this->value)<1)){
							if(is_array($this->value)){
								$vr=$this->vocabulary[array_pop($this->value)];
							} else {
								$vr=$this->vocabulary[$this->value];
							}
						} else {
							foreach ($this->value as $key=>$val){
								if($vr){
									$vr.='<br>';
								}
								if(isset($val)){
									$vr.=$this->vocabulary[$val];
								}
							}
						}
						$tpl->set_var('VRIJEDNOST',$vr ? $vr :'&nbsp;');
					}
					
					break;
				}
				default:{		
					if($this->change[$usertype]=='true' || ($usertype=='admin' && $new)){	
						if($this->multiple=='false' || !isset($this->value) || (is_array($this->value) && count($this->value)<1)){							
							$tpl->set_var('visestr_brisi','');
							$tpl->set_var('DULJINA',$this->attrtype['length'] ? $this->attrtype['length'] : '255');
							if($this->multiple=='true'){
								$vri='';
								$tpl->set_var('NAZIV_INPUT',$this->ldapname . '[0]');
							} else {
								$vri=$this->value;
								$tpl->set_var('NAZIV_INPUT',$this->ldapname);
							}
							
							if($prefix){
								if($vri){
								//	print "<br><br>\n\n\nprefix=$prefix vri=$vri|";
								//	print_r($this->{$this->ldapname . '_prefix'});
									foreach ($this->{$this->ldapname . '_prefix'} as $val){
									//	print "\nval:$val";
										if(substr($vri,0, strlen($val))==$val){
									//		print " -> nasao";
											$vri=substr($vri,strlen($val)+1);
											$vri=trim($vri);
											$vri_prefix=$val;
										}
								//		print " -> vri_poslije:$vri|\n";
									}
								}
								$tpl->set_var('VRIJEDNOST_PREFIX',$vri_prefix);
								if($this->multiple=='true'){
									$tpl->set_var('NAZIV_INPUT_PREFIX',$this->ldapname . '_prefix[0]');
								} else {
									$tpl->set_var('NAZIV_INPUT_PREFIX',$this->ldapname . '_prefix');
								}
							}
							$tpl->set_var('VRIJEDNOST',$vri);	
							$tpl->parse('visestr_input','visestr_input_tpl');
							$tpl->parse('visestr_blok','visestr_blok_tpl');	
							$tpl->parse('atr_blok','atr_blok_tpl');
							$tpl->set_var('visestr_zadnji_blok','');
						} else {
							foreach ($this->value as $key=>$val){
								$tpl->set_var('DULJINA',$this->attrtype['length'] ? $this->attrtype['length'] : '255');
								
								if($prefix){
									foreach ($this->{$this->ldapname . '_prefix'} as $v){
										if(substr($val,0,strlen($v))==$v){
											$val=substr($val,strlen($v)+1);
											$val=trim($val);
											$val_prefix=$v;
										}
									}
									//print_r($this->{$this->ldapname . '_prefix'});
									$tpl->set_var('VRIJEDNOST_PREFIX',$val_prefix);
									$tpl->set_var('NAZIV_INPUT_PREFIX',$this->ldapname . '_prefix[' . $key .']');
								}
								
								$tpl->set_var('VRIJEDNOST',$val);
								$tpl->set_var('NAZIV_INPUT',$this->ldapname . '[' . $key .']');
								$tpl->set_var('OBRISI_URL','index.php?' . $action .'&' . $show . '&uida=' .$uid .'&attr_name=' . $this->ldapname . '[' . $key .']&' .$attrs);
								if($this->schematype!='person'){
									$tpl->set_var('visestr_brisi','<br>');
								} else {
									if(($this->must=='true' && count($this->value)<2) || $new){
										$tpl->set_var('visestr_brisi','<br>');
									} else {
										$tpl->parse('visestr_brisi','visestr_brisi_tpl');
									}
								}
								$tpl->parse('visestr_input','visestr_input_tpl');
								$tpl->parse('visestr_blok','visestr_blok_tpl',true);
							}
							if(!$new && $this->schematype=='person'){
								$tpl->parse('visestr_zadnji_blok','visestr_zadnji_blok_tpl');
							} else {
								$tpl->set_var('visestr_zadnji_blok','');
							}
							$tpl->parse('atr_blok','atr_blok_tpl',true);
						}
					} else {
						if($this->multiple=='false' || !isset($this->value) || (is_array($this->value) && count($this->value)<1)){
							if(is_array($this->value)){
								$vr=array_pop($this->value);
							} else {
								$vr=$this->value;
							}
						} else {
							foreach ($this->value as $key=>$val){
								if($vr){
									$vr.='<br>';
								}
								$vr.=$val;
							}
						}
						$tpl->set_var('VRIJEDNOST',$vr ? $vr :'&nbsp;');
					}
					
					break;
				}
				
			}
			$tpl->parse('output','atr');
			$this->html=$tpl->get_var('output');
		} else {
			return '';
		}
		
	}
	
	function get_message(){
		return $this->message;
	}
	
}


?>
