<?PHP

class Org{
	
	var $message;
	var $status=true;
	var $result;
	var $urn_attributes=array();
	var $debug=false;
	
	
	
	function get_admin_privileges(){
		$admin_privileges=unserialize($_SESSION['admin_privileges']);
   	 	if(is_array($admin_privileges)){
   	 		foreach ($admin_privileges as $arr) {
   	 			if(is_array($arr)){
	   	 			foreach ($arr as $ldapname=>$values) {
	   	 				foreach($values as $key=>$value){
	   	 					if($ldapname=='hrEduPersonAffiliation'){
	   	 						$admin['hrEduPersonPrimaryAffiliation'][$value]=$value;
	   	 					}
	   	 					$admin[$ldapname][$value]=$value;
	   	 				}
	   	 			}
   	 			}
   	 		}
   	 	}
   	 	return $admin;
	}
	
	
	function make_urn($urn_value){
		$urn='';
		$attrs=$this->urn_attributes;
		foreach ($attrs as $ldapname){
			if(is_array($urn_value[$ldapname])){
				foreach ($urn_value[$ldapname] as $pvalue){
					if($urn!=''){
						$urn.=':';
					}
					$urn.=$ldapname . ":" . $pvalue;
				}
			}
		}
		if($urn && $urn!=''){
			$urn="urn:administrator imenika:" . $urn;
		} else {
			$urn="administrator imenika";
		}
		return $urn;
	}
	
	function get_result(){
		return $this->result;
	}
	
	function get_upload_logo_form_html($message=false){		
		$upload_form_tpl = new Template(CLASS_INCLUDE_PATH . "org/tpl/", 'comment');
   	 	$upload_form_tpl->set_file('upload_form', 'upload_logo_form.html');

   	 	$upload_form_tpl->set_var('MESSAGE',$message);
   	 	
   	 	$upload_form_tpl->parse('output', 'upload_form');	
		return $upload_form_tpl->get_var('output');
	}
	
	function upload_logo(){
		if($_SESSION['usertype']=='admin' && ($_SESSION['admintype']==1 || $_SESSION['admintype']==2)){
			$remoteFile = $_FILES['datoteka']['name'];
			$fileType = $_FILES['datoteka']['type'];
			$fileSize = $_FILES['datoteka']['size'];
			$fileTmpName = $_FILES['datoteka']['tmp_name'];
		
			$errMessages = array (
					m(37),
					m(38) . ": " . m(39),
					m(38) . ": " . m(39),
					m(38) . ": " . m(40),
					m(38) . ": " . m(41),
					m(38) . ": " . m(42),
					m(38) . ": " . m(43)
			);
		
			if (strlen($remoteFile) == 0) {
				$error = 5;	
			} elseif ($fileSize < 1) {
				$error = 6;
			} else $error = $_FILES['datoteka']['error'];
			
			if($error==0){
				//stara slika
				$old_img_path=INST_IMG_DIR_PATH . @file_get_contents(INST_IMG_INFO_PATH);
				$new_img_path= INST_IMG_DIR_PATH . $remoteFile;
				if($this->debug){
					print "moving: tmp_file: $fileTmpName<br>\nto:$new_img_path";
				}
				if(@move_uploaded_file($fileTmpName, $new_img_path)){
					if($new_img_path != $old_img_path){
						@unlink($old_img_path);
						@file_put_contents(INST_IMG_INFO_PATH, $remoteFile);
					}
				}
				return true;
			} else {
				$this->message=$errMessages[$error];
				return false;
			}
		} else {
			return false;
		}
		
	}
	
	function delete_logo(){
		if($_SESSION['usertype']=='admin' && ($_SESSION['admintype']==1 || $_SESSION['admintype']==2)){
			//stara slika
			$old_img_path=INST_IMG_DIR_PATH . @file_get_contents(INST_IMG_INFO_PATH);
			$ok_del =@unlink($old_img_path);
			file_put_contents(INST_IMG_INFO_PATH,'');
			return $ok_del;
		} else {
			return false;
		}
	}
	
	function get_edit_html($type='all',$message=false,$post_arr=false){	
			
		if($schema=load_schema('org')){
			$pom=$this->get_org_data(true);
			$userdata=$pom[BASE_DN];
			if($this->debug){
				print "<pre>org data:\n";
				var_dump($userdata);
				print "\n\nschema:\n";
				var_dump($schema);
				print "\n</pre>\n";
			}
			if(is_array($userdata)){
				//print "atributi:\n";
				foreach($schema->attribute as $key=>$attr){
					if($this->debug){
						print "key:$key\n";
						var_dump($attr);
					}
					if(($type=='must' && $attr->must=='true') || $type=='all'){
						if(is_array($userdata[$attr->ldapname])){
							//print_r($userdata[$attr->ldapname]);
							foreach ($userdata[$attr->ldapname] as $k => $v) {
								if(trim($v)!=''){
									$ok=true;
								}							
							}
							if($ok){
								$schema->attribute[$key]->set_value($userdata[$attr->ldapname]);
							}
						} else {
							if(isset($userdata[$attr->ldapname]) && trim($userdata[$attr->ldapname])!=''){
								$schema->attribute[$key]->set_value($userdata[$attr->ldapname]);
							}
						}
					}
				}
				$schema->make_html($type,$message,'admin');
				$html=$schema->get_html();
				$schema->unset_html();
				$_SESSION['org_schema']=serialize($schema);
			} else {
				return join('',file(TPL_INCLUDE_PATH . 'error.html'));
			}
			return $html;
		} else {
			return join('',file(TPL_INCLUDE_PATH . 'error.html'));
		}
			
	}
	
	function get_org_data($admin){
		global $soap_params;
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			if($admin){
				$method='ldapOrgInfo';
			} else {
				$method='userOrgInfo';
			}
			$result = $client->__soapCall($method, array($_SESSION['uid'],$_SESSION['password'],BASE_DN));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		
		if($this->debug){
			print "code:" . $result['code'] ."\n";
			print "<pre>result:\n";
			var_dump($result['result']);
			print "\n</pre>\n";
		}
		if($result['code']===0){
			return xml_to_array($result['result']);
		} else {
			$this->result=xml_to_array($result['result']);
			$this->message.= $this->result[BASE_DN]['message'];
			$this->message.= $this->result[BASE_DN]['plugin_message'];
			$this->message.= '<br>' . $result['error'];
			return false;
		}
		
	}
	
	function edit_org($post_array,$type='all'){
		if($this->debug){
			print "post_array:\n";
			print_r($post_array);
		}
		$padd_attr=array('o','street','postalCode','l');
		$chgpaddr=false;
		$dn=BASE_DN;
		$newschema=load_schema('org');
		$oldschema=unserialize($_SESSION['org_schema']);
		if($oldschema){
			// promjena vrijednosti atributa
			$ok=true;				
			foreach ($post_array as $ldapname => $attrvalue) {
				if(isset($newschema->attribute[$ldapname])){
					$attr=$newschema->attribute[$ldapname];
					if(is_array($attrvalue)){
						foreach ($attrvalue as $k => $v){
							if($v==''){
								unset($attrvalue[$k]);
							}
						} 
					}
					if(isset($post_array[$ldapname . '_prefix'])){
						$pref=$post_array[$ldapname . '_prefix'];
						if(is_array($attrvalue)){
							foreach ($attrvalue as $k => $v){
								if($v!=''){
									$attrvalue[$k]=$pref[$k] . ': ' .$attrvalue[$k];
								}
							} 
						} else {
							if($attrvalue!=''){
								$attrvalue=$pref . ': ' .$attrvalue;
							}
						}
						if($this->debug){
							print "attrvalue:\n";
							print_r($attrvalue);
						}
					}
					if($oldschema->attribute[$ldapname]->value!=$attrvalue){
						if($this->debug){
							print "<br><br>tip:$type<br>ldapname:$ldapname<br>";
							print "staro:";
							print_r($oldschema->attribute[$ldapname]->value);
							print "<br>novo:";
							print_r($attrvalue);
						}

						if(($attr->must=='true' && $type=='must') || $type=='all'){
							if($attr->validate($attrvalue,'admin')){
								if (isset($attrvalue)) {
									if(in_array($ldapname, $padd_attr)){
										$chgpaddr=true;
									}
									if(is_array($attrvalue)){
										foreach ($attrvalue as $key=>$val) {
											if($pom=$this->conv_attr_value($ldapname,$val,$attr->type)){
												$attr_array[$dn][$ldapname][$key]=$pom;
											}
										}
									} else {
										if($pom=$this->conv_attr_value($ldapname,$attrvalue,$attr->type)){
											$attr_array[$dn][$ldapname]=$pom;
										} else {
											$attr_array[$dn][$ldapname]='';
										}
									}
								}
							} else {
								$ok=false;
								$this->message.=$attr->get_message();
							}
						}
					}
				}
			}
			if($ok){
				$req=new Ldap_request();
				if(is_array($attr_array)){
					if($chgpaddr){
						foreach($padd_attr as $a){
							if(isset($attr_array[$dn][$a])){
								$attr_array[$dn]['postalAddress'].= $attr_array[$dn][$a][0] . ', ';
							} else {
								$attr_array[$dn]['postalAddress'].= $oldschema->attribute[$a]->value[0] . ', ';
							}
						}
						$attr_array[$dn]['postalAddress']=rtrim($attr_array[$dn]['postalAddress'],', ');
					}
					if($this->debug){
						print "chg: ";
						var_dump($attr_array);
						print "\n";							
					}
					
					//ako se modificirao naziv ustanove
					//upisati u  datoteku za prikaz 
					// trebalo bi poslije upisa u ldap ali predugo traje i mozda php ode u timeout
					if(isset($attr_array[BASE_DN]['o']) && INST_TITLE_PATH){
						file_put_contents(INST_TITLE_PATH, htmlentities($attr_array[BASE_DN]['o']));
					}
					if($res=$req->request($_SESSION['uid'],$_SESSION['password'],'ldapOrgModify',$attr_array,true)){
						$this->message.=$res['result'][$dn]['plugin_message'];
					} else {
						if($this->debug){
							print "result:\n";
							print_r($req->get_result());						
						}
						
						$this->result=$req->get_result();
						$this->message=$this->result[$dn]['message'];
						$this->message.=$this->result[$dn]['plugin_message'];
						$this->message.="<br>" . $req->get_message();
						$ok=false;
					}
				}
				if($ok){
					$this->message.=" " . m(79);
				}
				return $ok;
			} else {
				return false;
			}
		} else {
			$this->message=m(19);
			return false;
		}
	}
	
	
	function conv_attr_value($ldapname,$attrvalue=false,$type=false){
		if(!$type){
			$type=0;
		}
		if(isset($attrvalue) && trim($attrvalue)!=''){
			if($_SESSION['admintype']==3 && $ldapname=='hrEduPersonRole' && $attrvalue=='administrator imenika'){
				$retvalue=$this->make_urn($this->get_admin_privileges());
			} /*elseif($ldapname=='userPassword'){
				$retvalue='{SHA}' . base64_encode(pack("H*",sha1($attrvalue)));			
			} */
			elseif ($type==='binary'){
				//$retvalue=base64_encode($attrvalue);
				$retvalue=$attrvalue;
			} elseif ($type==='date') {
				$retvalue=conv_date_to_ldap(trim($attrvalue));
			} else {
				$retvalue=trim($attrvalue);	
			}
			return $retvalue;
		} else {
			return false;
		}
	}
	
	function get_message(){
		return $this->message;
	}
}


?>