<?PHP

class Ldap_request{
	
	var $message;
	var $result;
	var $debug=false;
		
	function array_to_xml($attrarray){
		$xml='<ldap>';
		if(is_array($attrarray)){
			foreach ($attrarray as $dn=>$entry){
				$xml.='<entry dn="' . $dn .'">';
				if(is_array($entry)){
					foreach ($entry as $ldapname=>$value){
						$xml.='<attribute ldapname="' . $ldapname .'">';
						if(is_array($value)){
							foreach ($value as $key=>$val){
								$val=htmlspecialchars ($val,ENT_QUOTES,'UTF-8');
								$xml.="<value>$val</value>";
							}
						} else {
							if($value!=''){
								$value=htmlspecialchars ($value,ENT_QUOTES,'UTF-8');
								$xml.="<value>" . $value . "</value>";
							}
						}
						$xml.="</attribute>";
					}
				}
				$xml.='</entry>';
			}
		}
		$xml.='</ldap>';
		return $xml;
	}
	
	function request($uid,$pwd,$method,$attr_array,$res_to_array=false,$arg_xml=false){
		global $soap_params;
		if($this->debug){
			print "<pre>request:\nmethod:$method:\nargs:\n";
			var_dump($attr_array);
			print "\nresult to array: ";
			print $res_to_array ? "true\n" : "false\n";
			print "arg is xml:";
			print $arg_xml ? "true\n" : "false\n";
			print "</pre>\n";
		}
		
		if(!$arg_xml){
			$xml=$this->array_to_xml($attr_array);
		} else {
			$xml=$attr_array;
		}

		if($this->debug){
			print "<pre>xml sent:$xml\n</pre>";
		}
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall($method, array($uid,$pwd,BASE_DN,$xml));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		
		if($this->debug){
			print "<pre>result raw:\n";
			var_dump($result);
			print "\n</pre>\n";
		}
		
		if ($result['code']===0){
			if($res_to_array){
				if(isset($result['result']) && $result['result']!=''){
					$result['result']=$this->xml_to_array($result['result']);
				}
			}
			$this->result=$result['result'];
			if($this->debug){
				print "<pre>result:\n";
				var_dump($result);
				print "\n</pre>\n";
			}
			return $result;
		} else {
			$this->message.=$result['error'];
			if($res_to_array){
				if(isset($result['result']) && $result['result']!=''){
					$this->result=$this->xml_to_array($result['result']);
				}
			} else {
				$this->result=$result['result'];
			}
			if($this->debug){
				print "<pre>error:\ncode:" . $result['code'] . "\nmessage:" . $result['error'] . "\nresult:\n";
				var_dump($result);
				print "\n</pre>\n";
			}
			
			return false;
		}
	}
		
	function get_result(){
		return $this->result;
	}
	
	function binary_search_request($uid,$pwd,$method,$filter,$attributes,$index){
		global $soap_params;
		
		if($this->debug){
			print "<pre>binary search request:\nmethod:$method:\nfilter:$filter\nattributes:$attributes\nindex:$index\n";
			print "</pre>\n";
		}
		
		try {
			$client = new SoapClient(null,$soap_params);
			// poziv metode web servisa
			$result = $client->__soapCall($method, array($uid,$pwd,BASE_DN,$filter,$attributes,$index));	
		} catch (Exception $e) {
			//greska u komunikaciji
			$this->message=$e -> getMessage ();
			if($this->debug){
				print "<pre>SOAP ERROR:\nmessage:" . $this->message;
				print "\n</pre>\n";
			}
			return false;
		}
		if($this->debug){
			print "<pre>result raw:\n";
			var_dump($result);
			print "\n</pre>\n";
		}
		if($result['code']===0){
			if(isset($result['result']) && $result['result']!=''){
				$res=$this->xml_to_array($result['result'],false);
			}
			if($this->debug){
				print "<pre>result:\n";
				var_dump($result);
				print "\n</pre>\n";
			}
			return $res;
		} else {
			if($this->debug){
				print "<pre>error:\ncode:" . $result['code'] . "\nmessage:" . $result['error'];
				print "\n</pre>\n";
			}
			$this->message.=$result['error'];
			return false;
		}
		
	}
	function get_message(){
		return $this->message;
	}
	
	function xml_to_array($xml,$utf8_decode_to=false){
		
		$p = xml_parser_create('UTF-8');
		xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);
	    xml_parser_set_option($p, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($p, $xml, $vals);
		xml_parser_free($p);

		foreach($vals as $val){
			switch ($val['tag']){
				case 'entry':
					switch ($val['type']){
						case 'open':
							$dn=$val['attributes']['dn'];
							$admintype=$val['attributes']['admintype'];
							$attributes=array();
						break;
						case 'complete':
							if(isset($val['attributes']['dn'])){
								$usrlist[$val['attributes']['dn']]=array();
								if(isset($val['attributes']['admintype'])){
									$usrlist[$val['attributes']['dn']]['aosi_admintype']=$val['attributes']['admintype'];
								}
							}
						break;
						case 'close':
							if($attributes['plugin_message'] && $attributes['plugin_message']!=''){
								$ts=time() . (rand()%10);
								$attributes['plugin_message']='Greška u pluginu <a onClick="javascript: expandcontract(\'' . $ts . '\',this);" style="cursor: pointer; cursor: hand;" title="Klikni ovdje za detalje">+</a><br><table width="100%" border=0 id="' . $ts . '" style="display:none"><tr><td><b>Naziv</b></td><td><b>Status</b></td><td><b>Poruka</b></td></tr>' . $attributes['plugin_message'] . '</table>';
							}
							$usrlist[$dn]=$attributes;
							if($admintype){
								$usrlist[$dn]['aosi_admintype']=$admintype;
							}
							unset($admintype);
						break;
					}
					break;
				case 'urn':
					if($val['type']=='open' || $val['type']=='complete'){
						$urnpair=array();
					} elseif ($val['type']=='close'){
						array_push($attributes,$urnpair);
					}
					break;
				case 'urn_value':
					if(!is_array($urnpair[$val['attributes']['ldapname']])){
						$urnpair[$val['attributes']['ldapname']]=array();
					}
					if($utf8_decode_to && gettype($val['value'])=='string'){
						array_push($urnpair[$val['attributes']['ldapname']],iconv('UTF-8',$utf8_decode_to,trim($val['value'])));
					} else {
						array_push($urnpair[$val['attributes']['ldapname']],trim($val['value']));
					}
					break;
				case 'attribute':
					if($val['type']=='open' || $val['type']=='complete'){
						$ldapname=$val['attributes']['ldapname'];
						unset($attrvalue);
					} elseif ($val['type']=='close'){
						if(count($attrvalue)<2){
							$attributes[$ldapname]=array_pop($attrvalue);
						} else {
							$attributes[$ldapname]=$attrvalue;
						}
					}
					break;
				case 'status':
					$attributes['code']=$val['attributes']['code'];
					if($utf8_decode && gettype($val['value'])=='string'){
						$attributes['message'].=iconv('UTF-8',$utf8_decode_to,$val['value']);
					} else {
						$attributes['message'].=$val['value'];
					}
					$attributes['message'].="<br>\n";
					break;
				case 'after_plugin_status':
				case 'before_plugin_status':
					if($val['attributes']['code']!=0){
						$attributes['plugin_message'].='<tr><td>';
						if($val['tag']=='after_plugin_status'){
							$attributes['plugin_message'].='poslije ';
						}
						$attributes['plugin_message'].=$val['attributes']['name'] . '</td><td>' . $val['attributes']['code'] .'</td><td>';
						if($utf8_decode && gettype($val['value'])=='string'){
							$attributes['plugin_message'].=iconv('UTF-8',$utf8_decode_to,$val['value']);
						} else {
							$attributes['plugin_message'].=$val['value'];
						}
						$attributes['plugin_message'].="</td></tr>\n";
					}
					break;
				case 'value':
					if($utf8_decode_to){
						if(gettype($val['value'])=='string'){
							$attrvalue[]=iconv('UTF-8',$utf8_decode_to,  htmlspecialchars_decode(trim($val['value']), ENT_QUOTES));
						} else {
							$attrvalue[]=trim($val['value']);
						}
					} else {
						$attrvalue[]=htmlspecialchars_decode(trim($val['value']), ENT_QUOTES);
					}
					break;
			}
		}
		return $usrlist;
	}
	
}

?>