<?php

class Schema{
	var $type;
	var $attribute;
	var $message;
	var $html;
	var $dn;
	var $debug=false;
	//obavezni atributi kod dodavanja novog korisnika
	var $obligatory_attr=array('uid','hrEduPersonOIB','userPassword','givenName','sn','mail','hrEduPersonPrimaryAffiliation','hrEduPersonExpireDate');
	//neobavezni atributi koji se pokazuju u formi kod dodavanja novog korisnika
	var $non_obligatory_attr=array('ou');
	//slova dozvoljena za password
	var $pwd_ch='abcdefghijkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ';
	//znamenke dozvoljene za password
	var $pwd_nu='23456789';
	//atributi koji se vide na izvjestaju
	var $print_fields=array('o','cn','hrEduPersonUniqueID','mail','uid','hrEduPersonExpireDate');
	
	function __construct ($schemaxml,$get_new_vocabularies=false,$type='person'){
		
		if($type!='org'){
			$type='person';
		}
		$this->type=$type;
		
		$p = xml_parser_create('UTF-8');
		xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);
	    xml_parser_set_option($p, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($p, $schemaxml, $vals,$index);
		
		xml_parser_free($p);
		$ind=$index['attribute'];
		//print_r($index);
		unset($index);
		$i=0;
		$ok=true;
/*
		print_r($ind);
		print_r($vals);
		die();
*/
		while($i<count($ind) && $ok){
			if($vals[$ind[$i]]['tag']=='attribute' && $vals[$ind[$i]]['type']=='open'){
				$ldapname=$vals[$ind[$i]]['attributes']['ldapname'];
				$start=$ind[$i];
				while($vals[$ind[$i]]['type']!='close' && $i<count($ind)){
					$i++;
				}
				if($vals[$ind[$i]]['type']!='close'){
					$this->message.=" $ldapname :" . m(11) . " 1!";
					//print_r($ind);
					//print_r($vals);
					//print "<pre>i=$i\nind[i]= " . $ind[$i] . "\nvals[type]=" . $vals[$ind[$i]]['type'] . "\n</pre>";
					$ok=false;
				} else {
					$end=$ind[$i];
					$attr_def_array=@array_slice($vals,$start,$end-$start);
					/*
print $ldapname . ": ";
					print_r($attr_def_array);
*/
					$this->attribute[$ldapname]=new AAIAttribute($attr_def_array,$get_new_vocabularies);
					//print_r($this->attribute[$ldapname]);		
					if($mess=$this->attribute[$ldapname]->get_message()){
						$this->message.=" " .$ldapname.": " .$mess;
					}
					$i++;
				}
			} else {
				//print_r($this);
				$this->message.=" $ldapname :" . m(11) . " 2!";
				
			//	print "\ni:$i\nval[tag]=" . $vals[$ind[$i]]['tag'] . "\nval[type]=" . $vals[$ind[$i]]['type'];
				die($this->message);
				$ok=false;
			}
		}
	}
	
	function save($path=false){
		if(!$path){
			if($this->type=='org'){
				$path=STAZA_DO_SCHEME . 'org_schema.obj';
			} else {
				$path=STAZA_DO_SCHEME . 'schema.obj';
			}
		}
		$pom=serialize($this);
		if($fp = fopen($path, 'w')){
			if(!fwrite($fp, $pom)){
				$this->message.= m(12) . " $path.";
				return false;
			}
	  		fclose($fp);
	  		return true;
		} else {
			$this->message.=m(13) . " $path.";
			return false;
		}
	}
	
	function get_html(){
		return $this->html;
	}
	
	function unset_html(){
		unset($this->html);
		if(is_array($this->attribute)){
			foreach ($this->attribute as $attr){
				$attr->unset_html();
			}
		}
	}
	function set_attribute($attribute,$value){
		if($this->attribute[$attribute]->set_value($value)){
			return true;
		} else {
			$this->message.=$this->attribute[$attribute]->get_message;
			return false;
		}
	}
	
	function validate_attribute($attribute,$value){
		if($this->attribute[$attribute]->validate($value)){
			return true;
		} else {
			$this->message.=$this->attribute[$attribute]->get_message;
			return false;
		}
	}
	
	function validate_all($atr_array){
		$ok=true;
		foreach ($atr_array as $key=>$val) {
			if(!$this->validate_attribute($key,$val)){
				$ok=false;
			}		
		}
		return $ok;
	}
	
	function set_all($atr_array){
		$ok=true;
		foreach ($atr_array as $key=>$val) {
			if(!$this->set_attribute($key,$val)){
				$ok=false;
			}
		}
		return $ok;
	}
	function get_message(){
		return $this->message;
	}
	
	function set_message($message=false){
		$this->message=$message;
	}
	
	function make_new_html($message=false){
		
		if($this->type=='org'){
			$pref='org_';
		}
		
		if(is_array($this->attribute)){
			$type='all';
			$tpl=new Template(CLASS_INCLUDE_PATH . 'schema/tpl','comment');
			$tpl->set_file('sch', $pref . 'schema.html');
			$tpl->set_block('sch','attr_type_tpl','attr_type');
			$tpl->set_block('sch','print_report_tpl','print_report');
			$tpl->set_block('sch','chg_pwd_tpl','chg_pwd');
			
			$all_attrs=array_merge($this->obligatory_attr,$this->non_obligatory_attr);
			foreach ($all_attrs as $key=>$val) {
				if($val=='userPassword'){
					$this->attribute[$val]->value=$this->pwdgen();
				}
				if($val=='hrEduPersonExpireDate' && !isset($this->attribute[$val]->value)){
					$this->attribute[$val]->value=get_default_hredupersonexpiredate();
				}
				$this->attribute[$val]->make_html($uid,$type,'admin',true);
				$html.=$this->attribute[$val]->get_html();
			}
			if($this->debug){
				print "Atributi:\n<br>";
				print_r($all_attrs);
			}
			$tpl->set_var('attr_type','');
			$tpl->set_var('print_report','');
			$tpl->set_var('chg_pwd','');
			
			$tpl->set_var('SUBMIT_VALUE','Dodaj');
			$tpl->set_var('SUBMIT_NAME','add_new');
			
			$tpl->set_var('URL_ACTION','index.php?show=edit_user&action=add_new&attributes=must');
			
			$tpl->set_var('MESSAGE',$message);
			$tpl->set_var('BODY',$html);
			$tpl->parse('output','sch');
			$this->html=$tpl->get_var('output');
			return true;
		} else {
			$this->html=join('',file(TPL_INCLUDE_PATH . 'error.html'));
			return false;
		}
		
		
	}
	
	function make_html($type='all',$message=false,$usertype,$new_password=false){
		if($this->type=='org'){
			$pref='org_';
		}
		if(is_array($this->attribute)){
			if($usertype=='admin'){
				$uid=$this->attribute['uid']->value;
			} else {
				$uid= $_SESSION['uid'];
			}
			$tpl=new Template(CLASS_INCLUDE_PATH . 'schema/tpl','comment');
			$tpl->set_file('sch', $pref . 'schema.html');
			$tpl->set_block('sch','attr_type_tpl','attr_type');
			$tpl->set_block('sch','print_report_tpl','print_report');
			$tpl->set_block('print_report_tpl','print_report_field_tpl','print_report_field');
			$tpl->set_block('sch','chg_pwd_tpl','chg_pwd');
			
			foreach ($this->attribute as $key=>$val) {

			//	print $key . "<br>";
			//	print $type . "<br>";
				$val->schematype=$this->type;
				$val->make_html($uid,$type,$usertype,false);
				
				switch($type){
					case 'all':{
						$html.=$val->get_html();
						break;
					}
					case 'must':{
						if($val->must=='true'){
							$html.=$val->get_html();
						}
						break;
					}
					case 'may':{
						if($val->must!='true'){
							$html.=$val->get_html();
						}
						break;
					}
				}
			//	print $html . "<br><br>";
			}
			if($new_password){
				$tpl->set_var('INPUT_VALUE',$new_password);
				$tpl->set_var('INPUT_NAME','print_userPassword');
				$tpl->parse('print_report_field','print_report_field_tpl',true);
				if($this->debug){
					print "report fields:\n";
				}
				foreach ($this->print_fields as $field_name){
					if($this->debug){
						print "$field_name\n";
					}
					$tpl->set_var('INPUT_NAME','print_' . $field_name);
					if(is_array($this->attribute[$field_name]->value)){
						$tpl->set_var('INPUT_VALUE',$this->attribute[$field_name]->value[0]);
					} else {
						$tpl->set_var('INPUT_VALUE',$this->attribute[$field_name]->value);
					}
					$tpl->parse('print_report_field','print_report_field_tpl',true);
				}
				$tpl->parse('print_report','print_report_tpl',true);
			} else {
				$tpl->set_var('print_report','');
			}
			
			$url_attr_type='index.php?attributes=';
			$url_action='index.php?';
			$url_add_attribute='index.php?template=new_attribute';
			if($usertype=='admin'){
				$url_action.='show=edit_user';
			} else {
				$url_action.='show=user_data';
			}
			if($type=='must'){
				$url_action.='&attributes=must';
				$url_attr_type.='all';
				$attr_type_text=m(14);
				$url_add_attribute.='&attributes=must';
			} else {
				$url_action.='&attributes=all';
				$url_attr_type.='must';
				$attr_type_text=m(15);
				$url_add_attribute.='&attributes=all';
			}
			$submit_name='edit_user';
			$submit_value=m(17);
			if($usertype=='admin'){
				$url_action.='&action=edit_user&uida=' . $this->attribute['uid']->value;
				$url_attr_type.='&show=edit_user&uida=' . $this->attribute['uid']->value;
				$url_add_attribute.='&uida=' . $this->attribute['uid']->value;
			} else {
				$url_action.='&action=chg_user_data&uida=' . $_SESSION['uid'];
				$url_attr_type.='&show=user_data&uida=' . $_SESSION['uid'];
				$url_add_attribute.='&uida=' . $_SESSION['uid'];
			}
			$url_chg_pwd=$url_add_attribute;
			$url_add_attribute.='&show=new_attribute';
			$tpl->set_var('URL_ADD_ATTRIBUTE', $url_add_attribute . '&attribute=');

			if($usertype=='admin'){
				$url_chg_pwd.='&show=chg_pwd_form';
				$tpl->set_var('URL_CHG_PWD',$url_chg_pwd);
				$tpl->parse('chg_pwd','chg_pwd_tpl');
			} else {
				$tpl->set_var('chg_pwd','');
			}
			
			
			
			$tpl->set_var('URL_ATTR_TYPE',$url_attr_type);
			$tpl->set_var('ATTR_TYPE_TEXT',$attr_type_text);
			$tpl->parse('attr_type','attr_type_tpl',true);
			if($this->type=='org'){
				$tpl->set_var('chg_pwd','');
				$tpl->set_var('print_report','');
				$tpl->set_var('attr_type','');
				$tpl->set_var('SUBMIT_NAME','edit_org');			
				$tpl->set_var('URL_ACTION','index.php?show=edit_org&attributes=all&action=edit_org');
			} else {
				$tpl->set_var('SUBMIT_NAME',$submit_name);			
				$tpl->set_var('URL_ACTION',$url_action);
			}
			$tpl->set_var('SUBMIT_VALUE',$submit_value);
			$tpl->set_var('MESSAGE',$message);
			$tpl->set_var('BODY',$html);
			$tpl->parse('output','sch');
			$this->html=$tpl->get_var('output');
			return true;
		} else {
			$this->html=join('',file(TPL_INCLUDE_PATH . 'error.html'));
			return false;
		}
		
		
	}
	
	function pwdgen(){
		
		$pwd_ch=str_shuffle($this->pwd_ch);
		$pwd_nu=str_shuffle($this->pwd_nu);
		$pwd_all=str_shuffle($pwd_ch . $pwd_nu);
		//bar dva slova
		$pwd=substr($pwd_ch,rand(0,strlen($pwd_ch)-1),1);
		$pwd.=substr($pwd_ch,rand(0,strlen($pwd_ch)-1),1);
		//bar dvije znamenke
		$pwd.=substr($pwd_nu,rand(0,strlen($pwd_nu)-1),1);
		$pwd.=substr($pwd_nu,rand(0,strlen($pwd_nu)-1),1);
		// i jos 4 znaka
		for($i=0;$i<4;$i++){
			$pwd.=substr($pwd_all,rand(0,strlen($pwd_all)-1),1);
		}
		// i jos malo pomjesati
		return str_shuffle($pwd);
	}
	
}


?>