<?php	
	
	function load_schema($type='person'){
		if($type=='org'){
			$ext='org_';
		} else {
			$type='person';
		}
		if(file_exists(STAZA_DO_SCHEME  . $ext . 'schema.obj')){
			$pomsch=@join('', file (STAZA_DO_SCHEME . $ext . 'schema.obj'));
			$schema=unserialize($pomsch);
		} else {
			if(get_local_schema_definition($type)){
				$pomsch=@join('', file (STAZA_DO_SCHEME . $ext . 'schema.obj'));
				$schema=unserialize($pomsch);
			} else {
				die(m(92));
			}
		}
		return $schema;
	}
	
	function get_new_schema_definition($type='person'){
		if($type=='org'){
			$local_schema=ORG_SCHEMA_DEFINITION_LOCAL;
			$remote_schema=ORG_SCHEMA_DEFINITION_LOCATION;
			$ext='org_';
		} else {
			$local_schema=SCHEMA_DEFINITION_LOCAL;
			$remote_schema=SCHEMA_DEFINITION_LOCATION;
			$type='person';
		}
		@copy($local_schema, $local_schema . ".old");
		if($newschema=join('', file ($remote_schema))){
			if($fp = @fopen($local_schema, 'w')){
				if(!@fwrite($fp, $newschema)){
					die(m(47) . " " . $local_schema);
					return false;
				}
		  		fclose($fp);
		  		$schema=new Schema($newschema,true,$type);
		  		if($schema->save()){
		  			return true;
		  		} else {
		  			die($schema->get_message());
		  			return false;
		  		}
			} else {
				die(m(47) . " " . $local_schema);
				return false;
			}
		} else {
			die(m(48) . " " . $remote_schema);
			return false;
		}
	}
	
	function get_local_schema_definition($type='person'){
		if($type=='org'){
			$local_schema=ORG_SCHEMA_DEFINITION_LOCAL;
		} else {
			$local_schema=SCHEMA_DEFINITION_LOCAL;
			$type='person';
		}
		if(file_exists($local_schema)){
			if($newschema=join('', file ($local_schema))){
		  		$schema=new Schema($newschema,false,$type);
		  		if($schema->save()){
		  			return true;
		  		} else {
		  			die($schema->get_message());
		  			return false;
		  		}
			} else {
				return get_new_schema_definition($type);
			}
		} else {
			return get_new_schema_definition($type);
		}
	}
	
	function make_new_vocabulary_obj($name){
		$vocabulary_local_xml=STAZA_DO_SIFRARNIKA . $name .".xml";
		$vocabulary_local_obj=STAZA_DO_SIFRARNIKA . $name .".obj";
		if($newvocabulary=join('', file($vocabulary_local_xml))){
			$p = xml_parser_create('UTF-8');
			xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);
		    xml_parser_set_option($p, XML_OPTION_SKIP_WHITE, 1);
			xml_parse_into_struct($p, $newvocabulary, $vals,$index);
			if(xml_get_error_code ( $p )){
				print m(93) . $name . ": " . $vocabulary_local_xml . "\n<br>";
				print "error:" . xml_error_string ( xml_get_error_code ( $p ) ) ."<br>\n";
				print "line: " . xml_get_current_line_number ( $p ) ."<br>\n";
				print "col: " . xml_get_current_column_number ( $p ) ."<br>\n";
				return false;
			} else {
				xml_parser_free($p);
				
				$ind=$index['vocabularyentry'];
				unset($index);
				$i=0;
				$ok=true;
				while($i<count($ind) && $ok){
					if($vals[$ind[$i]]['tag']=='vocabularyentry' && $vals[$ind[$i]]['type']=='complete'){
						$vocabulary[$vals[$ind[$i]]['attributes']['key']]=trim($vals[$ind[$i]]['value']);
					} else {
						$error.=m(94) . " $name 1!";
						$ok=false;
					}
					$i++;
				}
				if($ok){
					$pomsifr=serialize($vocabulary);
					if($fp=@fopen($vocabulary_local_obj,'w')){
						if(!@fwrite($fp, $pomsifr)){
							print m(95) . " $name : $vocabulary_local_obj .";
			  				return false;
						} else {
							fclose($fp);
							return $vocabulary;
						}
					}
				} else {
					print $error;
					return false;
				}
			}
		} else {
			print m(96) . " $name : $vocabulary_local_xml .\n";
			return false;
		}
		
	}
	
	function get_new_vocabulary($name,$uri){
		$vocabulary_local_xml=STAZA_DO_SIFRARNIKA . $name .".xml";
		$vocabulary_local_obj=STAZA_DO_SIFRARNIKA . $name .".obj";
		
		@copy($vocabulary_local_xml, $vocabulary_local_xml . ".old");
		
		if($newvocabulary=join('', file($uri))){
			if($fp =fopen($vocabulary_local_xml, 'w')){
				if(fwrite($fp, $newvocabulary)){
					fclose($fp);
			  		if(make_new_vocabulary_obj($name)){
			  			return true;	
			  		} else {
			  			die (m(93) . " $name.");
			  			return false;
			  		}
				} else {
					die(m(98) . " $name: $vocabulary_local_xml");
					return false;
				}
			} else {
				die(m(98) . " $name: $vocabulary_local_xml");
				return false;
			}
		} else {
			die(m(97) . " $name : $uri ");
			return false;
		}
	}
	
	function get_vocabulary($name,$uri){
		$vocabulary_local_xml=STAZA_DO_SIFRARNIKA . $name .".xml";
		$vocabulary_local_obj=STAZA_DO_SIFRARNIKA . $name .".obj";
		
		if(!file_exists($vocabulary_local_xml)){
			return get_new_vocabulary($name,$uri);
		} else {
			if($newvocabulary=join('', file($vocabulary_local_xml))){
		  		if(make_new_vocabulary_obj($name)){
		  			return true;	
		  		} else {
		  			die (m(93) . " $name.");
		  			return false;
		  		}
			} else {
				return get_new_vocabulary($name,$uri);
			}
		}
	}
	
	function load_vocabulary($name,$uri){
		$ok=false;
		$vocabulary_local_xml=STAZA_DO_SIFRARNIKA . $name .".xml";
		$vocabulary_local_obj=STAZA_DO_SIFRARNIKA . $name .".obj";
		
		if(file_exists($vocabulary_local_obj)){
			$pomsch=@join('', file ($vocabulary_local_obj));
			$vocabulary=unserialize($pomsch);
		} else {
			if(get_vocabulary($name,$uri)){
				$pomsch=@join('', file ($vocabulary_local_obj));
				$vocabulary=unserialize($pomsch);
			} else {
				die(m(97) . " $name : $uri ");	
			}
		}
		return $vocabulary;
	}
	
	function decode_result($result,$xml){
		
		$p = xml_parser_create('UTF-8');
		xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);
	    xml_parser_set_option($p, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($p, $xml, $vals,$index);
		xml_parser_free($p);
		foreach ($result as $key=>$val){
			if(gettype($val)=='string'){
				if($vals[$index[$key][0]]['attributes']['xsi:type']=='SOAP-ENC:base64'){
					$res[$key]=base64_decode($val);
				} else {
					$res[$key]=$val;
				}
			} else {
				$res[$key]=$val;
			}
		}
		return $res;
	}
	
	function array_to_xml($attrarray){
		$xml='<ldap>';
		foreach ($attrarray as $dn=>$entry){
			$xml.='<entry dn="' . $dn .'">';
			
			foreach ($entry as $ldapname=>$value){
				$xml.='<attribute ldapname="' . $ldapname .'">';
				if(is_array($value)){
						foreach ($value as $key=>$val){
							$val=htmlspecialchars ($val,ENT_QUOTES,'UTF-8');
							$xml.="<value>$val</value>";
						}
				} else {
					$value=htmlspecialchars ($value,ENT_QUOTES,'UTF-8');
					$xml.="<value>" . $value . "</value>";
				}
				$xml.="</attribute>";
			}
			$xml.='</entry>';
		}
		$xml.='</ldap>';
		return $xml;
	}
	function xml_to_array($xml,$utf8_decode_to=false){
		
		$p = xml_parser_create('UTF-8');
		xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);
	    xml_parser_set_option($p, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($p, $xml, $vals);
		xml_parser_free($p);
		//print_r($vals);
		foreach($vals as $val){
			switch ($val['tag']){
				case 'entry':
					switch ($val['type']){
						case 'open':
							$dn=$val['attributes']['dn'];
							$admintype=$val['attributes']['admintype'];
							$attributes=array();
						break;
						case 'complete':
							if(isset($val['attributes']['dn'])){
								$usrlist[$val['attributes']['dn']]=array();
								if(isset($val['attributes']['admintype'])){
									$usrlist[$val['attributes']['dn']]['aosi_admintype']=$val['attributes']['admintype'];
								}
							}
						break;
						case 'close':
							$usrlist[$dn]=$attributes;
							if($admintype){
								$usrlist[$dn]['aosi_admintype']=$admintype;
							}
							unset($admintype);
						break;
					}
					break;
				case 'urn':
					if($val['type']=='open' || $val['type']=='complete'){
						$urnpair=array();
					} elseif ($val['type']=='close'){
						array_push($attributes,$urnpair);
					}
					break;
				case 'urn_value':
					if(!is_array($urnpair[$val['attributes']['ldapname']])){
						$urnpair[$val['attributes']['ldapname']]=array();
					}
					if($utf8_decode_to && gettype($val['value'])=='string'){
						array_push($urnpair[$val['attributes']['ldapname']],iconv('UTF-8',$utf8_decode_to,trim($val['value'])));
					} else {
						array_push($urnpair[$val['attributes']['ldapname']],trim($val['value']));
					}
					break;
				case 'attribute':
					if($val['type']=='open' || $val['type']=='complete'){
						$ldapname=$val['attributes']['ldapname'];
						unset($attrvalue);
					} elseif ($val['type']=='close'){
						if(count($attrvalue)<2){
							$attributes[$ldapname]=array_pop($attrvalue);
						} else {
							$attributes[$ldapname]=$attrvalue;
						}
					}
					break;
				case 'value':
					if($utf8_decode_to && gettype($val['value'])=='string'){
						$attrvalue[]=iconv('UTF-8',$utf8_decode_to,htmlspecialchars_decode(trim($val['value']), ENT_QUOTES));
					} else {
						$attrvalue[]=htmlspecialchars_decode(trim($val['value']), ENT_QUOTES);
					}
					break;
			}	
		}
		return $usrlist;
	}
	
	function get_action_log($path=false){
		if(!$path && ACTION_LOG_PATH) {
			$path=ACTION_LOG_PATH;
		}
		if($path){
			$act_log='<?xml version="1.0"?>' . "\n";
			$act_log.='<?xml-stylesheet type="text/xsl" href="../action_log.xsl"?>' . "\n"; 
			$act_log.='<action_log>' . "\n";
			$act_log.=@file_get_contents($path);
			$act_log.='</action_log>';
			return $act_log;
		} else {
			return false;
		}
		
	}
	
	function chk_password_strength($pwd,$uid){
		$res=array(true,'');
		if(strlen($pwd)<8){
			$res[0]=false;
			$res[1]=m(23);
		}
		if(@preg_match_all('/\d/', $pwd, $pom_arr)<2){
			$res[0]=false;
			$res[1].=m(24);
		}
		if(@preg_match_all('/[a-zA-Z]/', $pwd, $pom_arr)<2){
			$res[0]=false;
			$res[1].=m(25);
		}
		if($pwd==$uid){
			$res[0]=false;
			$res[1].=m(26);
		}
		return $res;
	}
	
	function conv_date_from_ldap($date){
		if(is_array($date)){
			foreach($date as $k=>$v){
				if($v!='NONE'){
					$date[$k]=substr($v, -2) . '.' . substr($v, 4, 2) . '.' . substr($v, 0, 4) . '.';
				}
			}
		} else {
			if($date && $date!='NONE'){
				$date=substr($date, -2) . '.' . substr($date, 4, 2) . '.' . substr($date, 0, 4) . '.';
			}
		}
		return $date;
	}
	
	function get_default_hredupersonexpiredate(){
		$end_of_year='1031';
		if(DEFAULT_HREDUPERSONEXPIREDATE){
			return DEFAULT_HREDUPERSONEXPIREDATE;
		} else {
			$today_year = date('Y');
			if(date('md') >= $end_of_year){
				$today_year++;
			}
			return conv_date_from_ldap("$today_year$end_of_year");
		}
	}
	
	function conv_date_to_ldap($date){
		if(is_array($date)){
			foreach($date as $k=>$v){
				if($v!='NONE'){
					list($pomd,$pomm,$pomg)=explode('.',$v,3);
					$pomg=(int) $pomg;
					$pomm=(int) $pomm;
					$pomd=(int) $pomd;
					$date[$k]=substr("20$pomg", -4) . substr("00$pomm", -2) . substr("00$pomd", -2);
				}
			}
		} else {
			if($date && $date!='NONE'){
				list($pomd,$pomm,$pomg)=explode('.',$date,3);
				$pomg=(int) $pomg;
				$pomm=(int) $pomm;
				$pomd=(int) $pomd;
				$date=substr("20$pomg", -4) . substr("00$pomm", -2) . substr("00$pomd", -2);
			}
		}
		return $date;
	}
	

?>