package Plugins::o365connect;

use Net::LDAP::LDIF;
use Net::LDAP::Entry;
use Config::General;
use MIME::Base64;
use XML::Simple;
use Plugins::LDIFManip;
use Plugins::o365connectAttributes;
use Data::Dumper;

$VERSION  = 1.0;
my $plugin_name = 'o365connect';
$this_pkg = (caller(0))[0];
my $valid_attribs = [keys %{$Plugins::o365connectAttributes::attr_map}];

AOSICFG::write_ws_log('-=- ' . $this_pkg . '::'.$plugin_name.': valid attribs: ' . join(", ", @{$valid_attribs})) if $config::aosi_debug_level > 1;

my $conf = new Config::General(
    -ConfigFile      => $config::plugins_dir . '/'.$plugin_name.'.conf',
    -InterPolateVars => TRUE,
    -AutoLaunder     => TRUE
);
my %cfg = $conf->getall;

$config::ofc_file_prefix = $config::log_dir . '/' . $cfg{'ofc_file_prefix'};
$config::ofc_file_ext    = $cfg{'ofc_file_ext'};
$config::ofc_dump_file_prefix = $config::log_dir . '/' . $cfg{'ofc_dump_file_prefix'};
$config::ofc_dump_file_ext    = $cfg{'ofc_dump_file_ext'};
$config::ofc_logrotate_file_prefix = $config::log_dir . '/' . $cfg{'ofc_logrotate_file_prefix'};
$config::ofc_logrotate_file_ext    = $cfg{'ofc_logrotate_file_ext'};
@valid_ips                     = keys %{ $cfg{'ofc_valid_ip'} };
@valid_realms                  = keys %{ $cfg{'ofc_valid_realm'} };

AOSICFG::write_ws_log('-=- ' . $this_pkg . '::'.$plugin_name.': getting IP list: ' . join(", ", @valid_ips)) if $config::aosi_debug_level > 1;
AOSICFG::write_ws_log('-=- ' . $this_pkg . '::'.$plugin_name.': getting realm list: ' . join(", ", @valid_realms)) if $config::aosi_debug_level > 1;
AOSICFG::write_ws_log('-=- ' . $this_pkg . '::'.$plugin_name.': sync_file=' . $config::ofc_file_prefix . '_<realm>' . $config::ofc_file_ext)
  if $config::aosi_debug_level > 1;
AOSICFG::write_ws_log('-=- ' . $this_pkg . '::'.$plugin_name.': dump_file=' . $config::ofc_file_prefix . '_<realm>' . $config::ofc_dump_file_ext)
  if $config::aosi_debug_level > 1;
AOSICFG::write_ws_log('-=- ' . $this_pkg . '::'.$plugin_name.': logrotate_file=' . $config::ofc_logrotate_file_prefix . '_<realm>' . $config::ofc_logrotate_file_ext)
  if $config::aosi_debug_level > 1;
AOSICFG::write_ws_log('-=- ' . $this_pkg . '::'.$plugin_name.': logrotate_exe_path=' . $cfg{'ofc_logrotate_exe_path'} . '; logrotate_exe=' . $cfg{'ofc_logrotate_exe'})
  if $config::aosi_debug_level > 1;

##################################################################
#  Check if attribute is in the list of valid attributes
##################################################################
sub is_valid_attr {
    my ($in, $arr) = @_;
    my ($attr, $ok);

    $ok = 0;
    foreach $attr (@{$arr}) {
        chomp($attr);
        if ($attr eq $in) {
            $ok++;
        }
    }
    AOSICFG::write_ws_log('| is_valid_attr(out): Attribute ' . $in . ' is valid: ' . $ok) if $config::aosi_debug_level > 2;
    return $ok;
}

######################################################################
# Get LDIF for backup snyc purposess
######################################################################
# $type
# 1 = Get orig file info
# 2 = Get orig file and rotate
# 3 = Get rotated file info
# 4 = Get rotated file
# 5 = Get backup file info
# 6 = Backup all entries
# 7 = Get backup file
sub AOSI::o365connect {
      my ($service, $user, $pwd, $base, $type) = @_;
      my ($hash,   $out_msg, $log,  $dn,       $ldap, $ldap_error, $dec_pwd, $mesg,  $error, $code, $dummy);
      my ($filter, @entries, $port, $hostname, $num,  $file,       $file1,   $file0, $ldif,  @ldif, $sys, $run);
      my ($dev,    $ino,     $mode, $nlink,    $uid,  $gid,        $rdev,    $size,  $atime, $mtime, $ctime, $blksize, $blocks);
      my ($logrotate_file);
      $log = "Office365";

      AOSICFG::write_ws_log("/ $log(in):user:$user;base:$base;type:$type;") if $config::aosi_debug_level > 0;
      AOSICFG::write_ws_log("| $log: IP:$AOSI::client_ip;")                 if $config::aosi_debug_level > 1;

      $realm = Plugins::LDIFManip::base2realm($base);
	  # Dont check realms
	  #if(Plugins::LDIFManip::is_in_list($realm, \@valid_realms)){
          $file0 = $config::ofc_file_prefix . "_" . $realm . $config::ofc_file_ext;
          $file1 = $config::ofc_file_prefix . "_" . $realm . $config::ofc_file_ext . '.1';
          $file2 = $config::ofc_file_prefix . "_" . $realm . $config::ofc_dump_file_ext;
          if (($type == 1)) {
              $file = $file0;
          }
          elsif (($type >= 5) and ($type <= 7)) {
              $file = $file2;
          }
          else {
              $file = $file1;
          }
          AOSICFG::write_ws_log("| $log: LDIF_file=$file;") if $config::aosi_debug_level > 1;
          ($hostname, $port) = AOSICFG::parse_server($config::ldap_server);
          ($ldap, $ldap_error) = AOSICFG::ldap_init($hostname, $port);
          if ($user =~ /=/g) {
              $dn = $user . ',' . $base;
          }
          else {
              $dn = 'uid=' . $user . ',' . $base;
          }
          AOSICFG::write_ws_log("| $log: dn=$dn;") if $config::aosi_debug_level > 1;

          if (Plugins::LDIFManip::is_in_list($AOSI::client_ip, \@valid_ips)) {
              if ($ldap) {
                  $dec_pwd = decode_base64($pwd);
                  $mesg    = $ldap->bind($dn, password => $dec_pwd, version => 3);
                  $code    = $mesg->code;
                  $error   = $mesg->error;
                  if ($code == 0) {
                      if (($type == 1) or ($type == 3) or ($type == 5)) {    # LDIF file info
                          ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks) = stat($file);
                          if ($size eq '') {
                              $size = 0;
                          }
                          $out_msg = '<attribute ldapname="size"><value>' . $size . '</value></attribute>';
                          $out_msg .= '<attribute ldapname="modify_time"><value>' . AOSI::t2t($mtime) . '</value></attribute>';
                          $out_msg .= '<attribute ldapname="access_time"><value>' . AOSI::t2t($atime) . '</value></attribute>';
                          $out_msg .= '<attribute ldapname="file"><value>' . $file . '</value></attribute>';
                      }
                      elsif ($type == 2) {                                   # Get LDIF file
                          $ENV{'PATH'} = $cfg{'ofc_logrotate_exe_path'};
                          ($code, $logrot_file) = Plugins::LDIFManip::make_logrot($base, $config::ofc_logrotate_file_prefix . "_" . $realm . $config::ofc_logrotate_file_ext, $config::ofc_file_prefix . "_" . $realm . $config::ofc_file_ext);
                          AOSICFG::write_ws_log("| $log: logrot_file=$logrot_file;code=$code;") if $config::aosi_debug_level > 2;

                          # Perltidy escape
                        #<<<
                        $run = $cfg{'ofc_logrotate_exe'} . ' -f -v ' . $logrot_file . ' -s '
                               . $config::log_dir . '/' . $cfg{'ofc_logrotate_status_prefix'} . "_" . $realm . ' 2>&1';
                        #>>>
                          $sys = qx($run);
                          AOSICFG::write_ws_log("| $log: run=$run;sys=$sys;") if $config::aosi_debug_level > 2;
                          if ($sys =~ /error/g) {
                              $code    = -10901;
                              $out_msg = '<status code="' . $code . '">LDIF rotate error (' . $sys . ')!</status>';
                          }
                          elsif ($sys =~ /log does not need rotating/g) {
                              $out_msg .= '<attribute ldapname="size"><value>0</value></attribute>';
                              $out_msg .= '<attribute ldapname="warning"><value>LDIF is empty!</value></attribute>';
                          }
                          else {
                              open(LDIF, $file)
                                or do { $code = -10902; $out_msg = '<status code="' . $code . '">Can not open file ' . $file . '</status>'; $error = $!; };
                              @ldif = <LDIF>;
                              close(LDIF);
                              $ldif = join("", @ldif);
                              AOSICFG::write_ws_log("| $log: ldif=$ldif;") if $config::aosi_debug_level > 3;
                              ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks) = stat($file);
                              $ldif = XML::Simple::escape_value($dummy, $ldif);
                              $out_msg = '<attribute ldapname="ldif"><value>' . $ldif . '</value></attribute>';
                              $out_msg .= '<attribute ldapname="size"><value>' . $size . '</value></attribute>';
                          }
                      }
                      elsif (($type == 4) or ($type == 7)) {
                          open(LDIF, $file)
                            or do { $code = -10903; $out_msg = '<status code="' . $code . '">Can not open file ' . $file . '</status>'; $error = $!; };
                          if ($code == 0) {
                              @ldif = <LDIF>;
                              close(LDIF);
                              $ldif = join("", @ldif);
                              ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks) = stat($file);
                              $ldif = XML::Simple::escape_value($dummy, $ldif);
                              $out_msg = '<attribute ldapname="ldif"><value>' . $ldif . '</value></attribute>';
                              $out_msg .= '<attribute ldapname="size"><value>' . $size . '</value></attribute>';
                          }
                          close(LDIF);
                      }
                      elsif (($type == 6)) {
                          my $org_valid_attribs = ['hrEduOrgUniqueNumber', 'hrEduOrgOIB', 'postalAddress', 'l', 'postalCode', 'street', 'hrEduOrgMobile', 'hrEduOrgMail', 'hrEduOrgType', 'hrEduOrgURL'];
                          push(@$valid_attribs, @$org_valid_attribs);
                          ($code, $error) = Plugins::LDIFManip::dumpAll($ldap, $base, $valid_attribs, $file);
                          if ($code == 0) {
                              ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks) = stat($file);
                              AOSICFG::write_ws_log("\\ $log(out): file=$file; stat_size=$size; stat_atime=$atime" ) if $config::aosi_debug_level > 3;
                              $out_msg .= '<attribute ldapname="size"><value>' . $size . '</value></attribute>';
                              $error = '';
                          }
                          else {
                              $out_msg = '<status code="' . $code . '">' . $error . '</status>';
                          }
                      }
                      $mesg = $ldap->unbind;
                  }
                  else {
                      $out_msg = '<status code="' . $code . '">' . $error . '</status>';
                  }
              }
              else {
                  $code    = -10905;
                  $error   = $ldap_error;
                  $out_msg = '<status code="' . $code . '">' . $error . '</status>';
              }
          }
          else {
                $code    = -10906;
                $error   = 'You are not allowed to call this function!';
                $out_msg = '<status code="' . $code . '">' . $error . '</status>';
          }
	  #}
	  #else {
	  #    $code    = -10907;
	  #    $error   = 'Skipping for realm '.$realm.'!';
	  #    $out_msg = '<status code="' . $code . '">' . $error . '</status>';
	  #}
      $hash->{'code'}  = $code;
      $hash->{'error'} = $error;
      $hash->{'result'} =
        '<?xml version="1.0"?><ldap action="' . $log . '" version="' . $config::aosi_version . '"><entry dn="' . $dn . '">' . $out_msg . '</entry></ldap>';

      AOSICFG::write_ws_log("\\ $log(out):" . AOSICFG::dump_hash($hash)) if $config::aosi_debug_level > 0;
      return AOSI::hash2data($hash, { 'code' => 'int' });
}

##################################################################
#   beforeAddUser
##################################################################
sub beforeAddUser {
      my ($status_hash, $ldap, $base_dn, $entry_in, $user) = @_;
      my ($this_fun, $file, $msg, $code, $out_panic, $uid, $base);
      $this_fun  = (caller(0))[3];
      $msg       = $base_dn;
      $code      = 0;
      $out_panic = 0;

      AOSICFG::write_ws_log("|> $this_fun(in): base_dn=$base_dn;user=$user;entry_in=$entry_in;") if $config::aosi_debug_level > 1;
      ($uid, $base) = AOSICFG::get_uid_base($entry_in->{'dn'});
      AOSICFG::write_ws_log("|> $this_fun: base=$base") if $config::aosi_debug_level > 1;
      if (!Plugins::LDIFManip::cmp_dn($base, $base_dn)) {
          $code      = -10926;
          $msg       = "Admin user base DN ($base_dn) and entry base DN ($base) are different!";
          $out_panic = 1;
      }

      return $code, $msg, $out_panic;
}

##################################################################
#   afterAddUser
##################################################################
sub afterAddUser {
      my ($status_hash, $entry_in, $out_xml) = @_;
      my ($this_fun, $file, $msg, $code, $out_panic, $ip, $base, $realm);
      $this_fun  = (caller(0))[3];
      $msg       = '';
      $code      = 0;
      $out_panic = 0;

      AOSICFG::write_ws_log("|> $this_fun(in): \nentry_in=\n" . Plugins::dump_entry($entry_in) . "\nout_xml=\n" . $out_xml) if $config::aosi_debug_level > 1;
      $base = $status_hash->{$plugin_name}->{'before'}->{'msg'};
      AOSICFG::write_ws_log("|> $this_fun: base=$base") if $config::aosi_debug_level > 1;
      ($code, $msg) = Plugins::parse_ldap_xml($out_xml);
      $realm = Plugins::LDIFManip::base2realm($base);
	  #if(Plugins::LDIFManip::is_in_list($realm, \@valid_realms)){
              if ($code == 0) {
                  Plugins::LDIFManip::append_to_ldif($entry_in, 4, $base, $valid_attribs, $config::ofc_file_prefix . "_" . Plugins::LDIFManip::base2realm($base) . $config::ofc_file_ext);
              }
              else {  # Main action will report the error anyway
                  $code = 0;
              }
	  #}
	  #else {
	  #      AOSICFG::write_ws_log("|> $this_fun: Skipping for realm $realm!") if $config::aosi_debug_level > 1;
	  #}
      AOSICFG::write_ws_log("|> $this_fun(out): code=$code;msg=$msg;panic=$out_panic;") if $config::aosi_debug_level > 1;
      return $code, $msg, $out_panic;
}

##################################################################
#   beforeDeleteUser
##################################################################
sub beforeDeleteUser {
      my ($status_hash, $ldap, $base_dn, $entry_in, $user) = @_;
      my ($this_fun, $file, $msg, $code, $out_panic, $uid, $base);
      $this_fun  = (caller(0))[3];
      $msg       = $base_dn;
      $code      = 0;
      $out_panic = 0;

      AOSICFG::write_ws_log("|> $this_fun(in): base=$base_dn;user=$user;entry_in=$entry_in;") if $config::aosi_debug_level > 1;
      ($uid, $base) = AOSICFG::get_uid_base($entry_in->{'dn'});
      AOSICFG::write_ws_log("|> $this_fun: base=$base") if $config::aosi_debug_level > 1;
      if (!Plugins::LDIFManip::cmp_dn($base, $base_dn)) {
          $code      = -10427;
          $msg       = "Admin user base DN ($base_dn) and entry base DN ($base) are different!";
          $out_panic = 1;
      }

      return $code, $msg, $out_panic;
}

##################################################################
#   afterDeleteUser
##################################################################
sub afterDeleteUser {
      my ($status_hash, $entry_in, $out_xml) = @_;
      my ($this_fun, $file, $msg, $code, $panic, $out_panic, $realm);
      $this_fun  = (caller(0))[3];
      $msg       = '';
      $code      = 0;
      $out_panic = 0;

      AOSICFG::write_ws_log("|> $this_fun(in): \nentry_in=\n" . Plugins::dump_entry($entry_in) . "\nout_xml=\n" . $out_xml) if $config::aosi_debug_level > 1;
      $base = $status_hash->{$plugin_name}->{'before'}->{'msg'};
      AOSICFG::write_ws_log("|> $this_fun: base=$base") if $config::aosi_debug_level > 1;
      ($code, $msg) = Plugins::parse_ldap_xml($out_xml);
      $realm = Plugins::LDIFManip::base2realm($base);
	  #if(Plugins::LDIFManip::is_in_list($realm, \@valid_realms)){
              if ($code == 0) {
                  Plugins::LDIFManip::append_to_ldif($entry_in, 5, $base, $valid_attribs, $config::ofc_file_prefix . "_" . Plugins::LDIFManip::base2realm($base) . $config::ofc_file_ext);
              }
              else {  # Main action will report the error anyway
                  $code = 0;
              }
	  #}
	  #else {
	  #      AOSICFG::write_ws_log("|> $this_fun: Skipping for realm $realm!") if $config::aosi_debug_level > 1;
	  #}
      AOSICFG::write_ws_log("|> $this_fun(out): code=$code;msg=$msg;panic=$out_panic;") if $config::aosi_debug_level > 1;
      return $code, $msg, $out_panic;
}

##################################################################
#   before*Attribute
##################################################################
# Same function for all actions
# 1 = afterAddAttribute
# 2 = afterModifyAttribute
# 3 = afterDeleteAttribute
sub beforeChangeAttribute {
      my ($status_hash, $type, $ldap, $base_dn, $entry_in, $user, $pwd) = @_;
      my ($this_fun, $file, $out_panic, $uid, $base);
      $this_fun  = (caller(0))[3];
      $msg       = $base_dn;
      $code      = 0;
      $out_panic = 0;

      AOSICFG::write_ws_log("|> $this_fun(in): base=$base_dn;user=$user;entry_in=$entry_in;") if $config::aosi_debug_level > 1;
      ($uid, $base) = AOSICFG::get_uid_base($entry_in->{'dn'});
      AOSICFG::write_ws_log("|> $this_fun: base=$base") if $config::aosi_debug_level > 1;
      if (!Plugins::LDIFManip::cmp_dn($base, $base_dn)) {
          $code      = -10928;
          $msg       = "Admin user base DN ($base_dn) and entry base DN ($base) are different!";
          $out_panic = 1;
      }
      AOSICFG::write_ws_log("|> $this_fun(out): code=$code;msg=$msg;panic=$out_panic;") if $config::aosi_debug_level > 1;
      return $code, $msg, $out_panic;
}

##################################################################
#   after*Attribute
##################################################################
# Same function for all actions
# 1 = afterAddAttribute
# 2 = afterModifyAttribute
# 3 = afterDeleteAttribute
sub afterChangeAttribute {
      my ($status_hash, $type, $entry_in, $out_xml, $user, $pwd) = @_;
      my ($this_fun, $file, $out_panic, $entry);
      $this_fun  = (caller(0))[3];
      $msg       = '';
      $code      = 0;
      $out_panic = 0;
      AOSICFG::write_ws_log("|> $this_fun(in): \ntype=$type;\nentry_in=\n" . Plugins::dump_entry($entry_in) . "\nout_xml=\n" . $out_xml)
        if $config::aosi_debug_level > 1;
      $base = $status_hash->{$plugin_name}->{'before'}->{'msg'};
      AOSICFG::write_ws_log("|> $this_fun: base=$base") if $config::aosi_debug_level > 1;
      ($code, $msg) = Plugins::parse_ldap_xml($out_xml);
      $realm = Plugins::LDIFManip::base2realm($base);
	  #if(Plugins::LDIFManip::is_in_list($realm, \@valid_realms)){
              if ($code == 0) {
                  $entry = update_entry($entry_in, $base, $user, $pwd);
                  Plugins::LDIFManip::append_to_ldif($entry, $type, $base, $valid_attribs, $config::ofc_file_prefix . "_" . Plugins::LDIFManip::base2realm($base) . $config::ofc_file_ext);
              }
              else {  # Main action will report the error anyway
                  $code = 0;
              }
	  #}
	  #else {
	  #      AOSICFG::write_ws_log("|> $this_fun: Skipping for realm $realm!") if $config::aosi_debug_level > 1;
	  #}
      AOSICFG::write_ws_log("|> $this_fun(out): code=$code;msg=$msg;panic=$out_panic;") if $config::aosi_debug_level > 1;
      return $code, $msg, $out_panic;
}

##################################################################
#   Update data for LDIF entry so that only first value is present
##################################################################
sub update_entry {
    my ($h, $base, $user, $pwd) = @_;
    my ($frist_val, $this_fun, $att, $val, $first_val, $dn, $hash);
    $this_fun  = (caller(0))[3];
		$hash=clone_entry($h);
    $dn = $hash->{'dn'};
    foreach my $att_item (@{ $hash->{'attrs'} }) {
        if (ref($att_item) eq 'HASH') {
              $att = $att_item->{'att'};
              $val = $att_item->{'val'};
              if(Plugins::LDIFManip::is_in_list($att, $valid_attribs)){
                  AOSICFG::write_ws_log("|> $this_fun: att=$att;val=$val") if $config::aosi_debug_level > 3;
                  $first_val = fetch_first_val($dn, $base, $user, $pwd, $att);
              }
              $att_item->{'val'} = [$first_val];
        }
    }

    return $hash;
}

sub clone_entry {
    my ($ent) = @_;
    my ($this_fun, $hash,$attrs);
    $this_fun  = (caller(0))[3];
		$hash = {};
    $attrs= undef;
    $hash->{'dn'} = $ent->{'dn'};
    AOSICFG::write_ws_log("|> $this_fun: entry in: dn = " . Plugins::dump_entry($ent)) if $config::aosi_debug_level > 3;
    foreach my $att_item (@{ $ent->{'attrs'} }) {
        if (ref($att_item) eq 'HASH') {
		        push(@$attrs, { 'att' => $att_item->{'att'}, 'val' => $att_item->{'val'}, 'id' => $att_item->{'id'} });
        }
    }
    $hash->{'attrs'} = $attrs;
    AOSICFG::write_ws_log("|> $this_fun: entry out: dn = " . Plugins::dump_entry($hash)) if $config::aosi_debug_level > 3;
    return $hash;
}

##################################################################
#   Fetch first value for an attribute
##################################################################
sub fetch_first_val {
    my($dn, $base, $user, $pwd, $att) = @_;
    my ($this_fun, $filter, $attributes, $uid, $dummy, $first_val);
    $this_fun  = (caller(0))[3];
    ($uid, $dummy) = AOSICFG::get_uid_base($dn);
    $filter = '(uid='.$uid.')';
    $attributes = $att;

    AOSICFG::write_ws_log("|> $this_fun(in): pwd=$pwd;dn=$dn;base=$base;att=$att;filter=$filter;attrs=".join(",", @$attributes).";") if $config::aosi_debug_level > 3;
    $hash = AOSICFG::ldapGenSearch($this_fun, $user, $pwd, $base, $filter, $attributes, 0, -1, 0);

    $xml = XMLin($hash->{'result'}, ForceArray => [ 'entry', 'attribute', 'value' ]);
    $first_val = $xml->{'entry'}->[0]->{'attribute'}->[0]->{'value'}->[0];

    AOSICFG::write_ws_log("|> $this_fun(out): first_val=$first_val; hash=".AOSICFG::dump_hash($hash)) if $config::aosi_debug_level > 3;
    return $first_val;
}

1;
